/*!
  \file
  \brief ݒ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "AccessSettings.h"
#include "ResourceDefinition.h"
#include "AccessProperty.h"
#include "SystemDefinition.h"
#include "hyakutypingrc_orig.h"
#include "ExistFile.h"
#include "CreateDirectory.h"
#include "CreateFileFromArray.h"
#include <boost/lexical_cast.hpp>

using namespace beego;


struct AccessSettings::pImpl {
  AccessProperty* property_;

  pImpl(const char* savedir) : property_(NULL) {

    // f[^ۑpfBNg𐶐
    if (! createDirectory(savedir)) {
      // !!! G[bZ[W̏o
      return;
    }

    // ݒt@CȂ΁ARs[Đ
    std::string config_file = std::string(savedir) + ConfigFile;
    if (! existFile(config_file.c_str())) {
      createFileFromArray(config_file.c_str(), hyakutypingrc_orig,
                          sizeof(hyakutypingrc_orig) - 1);
    }
    property_ = new AccessProperty(config_file.c_str());
  }

  ~pImpl(void) {
    delete property_;
  }

  void swapUserSettings(int user_index, int remove_index) {

    const char* swap_tag[] = {
      "u_%02d", "u_%02d_http", "u_%02d_password", "u_%02d_converter",
      "u_%02d_total",
    };

    enum { BufferMax = 256 };
    char swap_buffer0[BufferMax];
    char swap_buffer1[BufferMax];

    AccessProperty& property = *property_;
    for (size_t i = 0; i < sizeof(swap_tag)/sizeof(swap_tag[0]); ++i) {
      sprintf(swap_buffer0, swap_tag[i], user_index);
      sprintf(swap_buffer1, swap_tag[i], remove_index);

      std::swap(property[swap_buffer0], property[swap_buffer1]);
    }
  }

  void initializeUserSettings(int remove_index) {

    const char* tag[] = {
      "u_%02d", "u_%02d_http", "u_%02d_password", "u_%02d_converter",
      "u_%02d_total",
    };

    enum { BufferMax = 256 };
    char buffer[BufferMax];

    AccessProperty& property = *property_;
    for (size_t i = 0; i < sizeof(tag)/sizeof(tag[0]); ++i) {
      sprintf(buffer, tag[i], remove_index);
      property[buffer] = "";
    }
  }
};


AccessSettings::AccessSettings(const char* savedir)
  : pimpl(new pImpl(savedir)), user_index_(0) {
  reload();
}


AccessSettings::~AccessSettings(void) {
}


void AccessSettings::reload(void) {

  if (! pimpl->property_) {
    return;
  }

  AccessProperty& property = *pimpl->property_;

  // VXeݒ̓ǂݏo
  effect_decide_ = property["effect_decide"];
  effect_type_ = property["effect_type"];
  effect_miss_ = property["effect_miss"];

  // [Uݒ̓ǂݏo
  user_names_.resize(UserMax);
  user_password_.resize(UserMax);
  for (int i = 0; i < UserMax; ++i) {
    char buffer[] = "u_xx";
    sprintf(buffer, "u_%02d", i);
    user_names_[i] = property[buffer];

    char password_tag[] = "u_xx_password";
    sprintf(password_tag, "u_%02d_password", i);
    user_password_[i] = property[password_tag];
  }
  user_index_ = atoi(property["u_index"].c_str());

  // [U̐ݒǂݏo
  // !!!
}


void AccessSettings::save(void) {

  // !!! isChangedByOthre() pāA㏑Ă悢ÅmFbZ[Woׂ͂
  // !!! ܁A

  if (! pimpl->property_) {
    return;
  }

  AccessProperty& property = *pimpl->property_;

  // [UCfbNX̋L^
  property["u_index"] = boost::lexical_cast<std::string>(user_index_);

  // [UApX[h̋L^
  for (int i = 0; i < UserMax; ++i) {
    char name_tag[] = "u_xx";
    sprintf(name_tag, "u_%02d", i);
    property[name_tag] = user_names_[i];

    char password_tag[] = "u_xx_password";
    sprintf(password_tag, "u_%02d_password", i);
    property[password_tag] = user_password_[i];
  }

  // !!!

  property.save();
}


void AccessSettings::deleteUser(int index) {

  if (index < 0) {
    return;
  }

  // oϐ̏
  // !!! iD...BAč蒼
  user_names_[index] = "";
  user_password_[index] = "";

  int remove_index = index;
  for (; remove_index < (UserMax - 1); ++remove_index) {
    if (strlen(user_names_[remove_index].c_str()) <= 0) {
      break;
    }
  }
  pimpl->initializeUserSettings(remove_index);
  pimpl->swapUserSettings(index, remove_index);

  if (static_cast<int>(user_index_) >= index) {
    --user_index_;
  }

  save();
}
