/*!
  \file
  \brief ܂莚̓͗K

  \author Satofumi KAMIMURA

  $Id$

  \todo ca̐ɕ\
  \todo ܂莚p̃VbtNXKp
*/

#include "KimarijiPractice.h"
#include "KimarijiPractice_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ResourceDefinition.h"
#include "CommonResources.h"
#include "PracticeMenu_uni.h"
#include "ShimonokuInput.h"
#include "ResultDrawer.h"
#include "GraphDrawer.h"
#include "TypingRecorder.h"
#include "ShuffleWaka.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputEvent.h"
#include "InputHandler.h"
#include "InputReceiveComponent.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "GetTicks.h"
#include "Delay.h"
#include "SdlUtils.h"
#include "UtfString.h"
#include <time.h>

using namespace beego;


struct KimarijiPractice::pImpl {

  class Schedule : public BaseEntity {
    bool is_terminated;
    StateMachine<Schedule>* state_machine;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      type->changeState(PrologueState::getObject(common));
    }

    void exit(Schedule* type) {

      // Q[̋L^
      int rand_seed = static_cast<int>(time(NULL));

      // â̏ԂVbt
      ShuffleWaka wakaShuffle(KimarijiTyping, rand_seed);
      wakaShuffle.shuffle(common->waka_order);

      // !!! d_K܂̎
      // !!!
      // wakaShuffle.shuffle();

      common->recorder->recordGame(rand_seed, TypingRecorder::KimarijiTyping);
    }
  };

  class PrologueState : public State<Schedule> {

    CommonResources* common;
    // !!! `܂͕ʃNXɂA肷邩
    TextProperty title_property;
    Surface title_surface;
    Component title_label;
    Surface subTitle_surface;
    Component subTitle_label;
    size_t first_ticks;

    PrologueState(CommonResources* common_obj)
      : common(common_obj),
        title_property(common->font, PracticeMenu_kimariji, TitleSize,
                       Fore, Back, true),
        title_surface(new TextSurface(title_property)),
        title_label(new LabelComponent(title_surface)) {
    }

  public:
    static PrologueState* getObject(CommonResources* common) {
      static PrologueState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // u܂莚^CsOvƕ\
      // !!! ̋^CsOƂقƂǓB邩ȁH
      SDL_Rect position;
      set_SdlRect(&position, centerPosition(title_label, 640/2),
                  middlePosition(title_label, 480/4 + SubOffset));
      title_label->setPosition(&position);

      // uX ṽx쐬
      std::vector<Uint16> num_str;
      char buffer[4];
      sprintf(buffer, "%d", common->practice_num);
      ustrcat(num_str, buffer);
      ustrcat(num_str, KimarijiPractice_PrologueSubTitle);
      TextProperty text_property(common->font, &num_str[0],
                                 LargeSize, Fore, Back, true);
      Surface new_surface(new TextSurface(text_property));
      std::swap(new_surface, subTitle_surface);

      Component new_label(new LabelComponent(subTitle_surface));
      std::swap(new_label, subTitle_label);

      set_SdlRect(&position, centerPosition(subTitle_label, 640/2),
                  topPosition(subTitle_label, 480/4 + MenuOffset) + SubOffset);
      subTitle_label->setPosition(&position);

      placeComponents();

      if (common->music) {
        // y̒~҂
        while (common->music->nowPlaying()) {
          delay(10);
        }

        // ʉ̍ĐJn
        common->sound_effect->play(SoundEffect_1);
      }
      first_ticks = GetTicks();
    }

    void execute(Schedule* type) {

      // ҋ@Ԃo߂ATypingState ֑Jڂ
      InputEvent input_event;
      common->input_receiver->updateInputEvent(input_event);
      size_t spent_msec = GetTicks() - first_ticks;
      if ((spent_msec >= PrologueMsec) ||
          (InputEvent::isReleased(input_event, SDLK_RETURN))) {
        type->changeState(TypingState::getObject(common));
      }
    }

    void exit(Schedule* type) {
      // zuR|[lg폜
      removeComponents();

      // ʉ̒~ƁAy̍Đ
      if (common->music) {

        // y̍Đ
        common->music->setNextMusic(BackMusic_2);
      }
    }

    void placeComponents(void) {
      common->front_layer->push_front(title_label);
      common->front_layer->push_front(subTitle_label);
      common->input_receiver->clear();
    }

    void removeComponents(void) {
      common->front_layer->remove(title_label);
      common->front_layer->remove(subTitle_label);

      if (common->music) {
        common->sound_effect->stop();
      }
    }
  };

  class TypingState : public State<Schedule> {
    CommonResources* common;
    ShimonokuInput kimariji_input;
    InputEvent input_event;
    size_t practice_left;
    bool typing_complete;

    TypingState(CommonResources* common_obj)
      : common(common_obj),
        kimariji_input(KimarijiTyping), typing_complete(false) {
    }

  public:
    static TypingState* getObject(CommonResources* common) {
      static TypingState obj(common);
      return &obj;
    }

    void setPracticeNum(size_t num) {
      practice_left = num;
    }

    void removeComponents(void) {
      kimariji_input.removeComponents();
    }

    void enter(Schedule* type) {
      typing_complete = false;
      kimariji_input.updateWaka();

      common->input_receiver->clear();
    }

    void execute(Schedule* type) {

      // ̋A̋A͌`
      kimariji_input.drawWaka();

      // ͊Aŝ҂
      common->input_receiver->updateInputEvent(input_event);
      if (typing_complete) {

        // s̓͂҂
        if (! InputEvent::isReleased(input_event, SDLK_RETURN)) {
          return;
        }

        if (practice_left <= 0) {
          // KAResultState ֑Jڂ
          type->changeState(ResultState::getObject(common));
        } else {
          // ēxAâ̓͂s
          kimariji_input.setNextWaka();
          type->changeState(TypingState::getObject(common));
        }
        return;
      }

      // ̋̓͗
      if (! typing_complete) {
        kimariji_input.drawInput();
      }

      // ͂玟̘â
      if (kimariji_input.isComplete()) {
        --practice_left;
        kimariji_input.removeInputComponents();
        typing_complete = true;

        if (common->music) {
          // ʉ̍Đ
          common->sound_effect->play(Decide);
        }
      }
    }

    void exit(Schedule* type) {
      // zuR|[lg폜
      removeComponents();
    }

    bool textEmpty(void) {
      return kimariji_input.textEmpty();
    }
  };

  class ResultState : public State<Schedule> {
    CommonResources* common;
    ResultDrawer result_drawer;
    size_t first_ticks;

    ResultState(CommonResources* common_obj)
      : common(common_obj), result_drawer(KimarijiTyping) {
      // !!!
    }

  public:
    static ResultState* getObject(CommonResources* common) {
      static ResultState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      // \p^C}[JE^̏
      result_drawer.createResult();
      first_ticks = GetTicks();
    }

    void execute(Schedule* type) {

      // ^CsO̕]\
      size_t ticks = GetTicks() - first_ticks;
      result_drawer.drawResult(ticks);

      // L[͂ȂǂŁAI
      if (result_drawer.keyPressed()) {
        type->changeState(GraphState::getObject(common));
      }
    }

    void exit(Schedule* type) {
    }

    void removeComponents(void) {
      result_drawer.removeComponents();
    }
  };

  class GraphState : public State<Schedule> {
    CommonResources* common;
    GraphDrawer graph_drawer;

    GraphState(CommonResources* common_obj)
      : common(common_obj), graph_drawer(ShimonokuTyping) {

      // Otp̏擾Agraph_drawer ɓn
      // !!!
    }

  public:
    static GraphState* getObject(CommonResources* common) {
      static GraphState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      // ʕ\̍폜
      ResultState::getObject(common)->removeComponents();

      // Ot̕`
      graph_drawer.drawGraph();
    }

    void execute(Schedule* type) {

      // L[͂ȂǂŁAI
      if (graph_drawer.keyPressed()) {
        type->changeState(FirstState::getObject(common));
      }
    }

    void exit(Schedule* type) {
    }

    void removeComponents(void) {
      graph_drawer.removeComponents();
    }
  };

  // !!! ̃NX́ÂƋʂɂȂ̂ŁA肽
  // !!! ƂA
  class WaitKeyState : public State<Schedule> {
    CommonResources* common;
    InputEvent input_event;
    State<Schedule>* next_state;

    WaitKeyState(CommonResources* common_obj, State<Schedule>* next_state_)
      : common(common_obj), next_state(next_state_) {
    }

  public:
    static WaitKeyState* getObject(CommonResources* common,
                                   State<Schedule>* next_state) {
      static WaitKeyState obj(common, next_state);
      return &obj;
    }

    void enter(Schedule* type) {
      common->input_receiver->clear();
    }

    void execute(Schedule* type) {
      common->input_receiver->updateInputEvent(input_event);
      if (InputEvent::isReleased(input_event, SDLK_RETURN)) {
        type->changeState(next_state);
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void removeComponents(void) {
    }
  };

  CommonResources* common;
  Schedule scheduler;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(GameSchedulerId, common) {
    TypingState::getObject(common)->setPracticeNum(common->practice_num);
  }

  void removeComponents(void) {
    PrologueState::getObject(common)->removeComponents();
    TypingState::getObject(common)->removeComponents();
    ResultState::getObject(common)->removeComponents();
    GraphState::getObject(common)->removeComponents();
    WaitKeyState::getObject(common, NULL)->removeComponents();
  }
};


KimarijiPractice::KimarijiPractice(void) : pimpl(new pImpl) {
}


KimarijiPractice::~KimarijiPractice(void) {
}


void KimarijiPractice::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  bool escape_pressed = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    quit |= pimpl->scheduler.isTerminated();
    input.update_all();
    gui->update();
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    if (pImpl::TypingState::getObject(pimpl->common)->textEmpty()) {
      escape_pressed |= input.isPressed(SDLK_ESCAPE);
      if (escape_pressed && input.isReleased(SDLK_ESCAPE)) {
        quit |= true;
      }
    }
    delay(1);
  }

  // eR|[lg̍폜
  pimpl->removeComponents();
}
