/*!
  \file
  \brief ^C}[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "CycleTimer.h"
#include "GetTicks.h"
#include "Delay.h"

using namespace beego;


struct CycleTimer::pImpl {
  size_t cycle_msec;
  bool times_exactly;
  size_t next_ticks;

  pImpl(size_t cycle_msec_, bool times_exactly_)
    : cycle_msec(cycle_msec_), times_exactly(times_exactly_),
      next_ticks(GetTicks() + cycle_msec) {
  }
};


CycleTimer::CycleTimer(size_t cycle_msec, bool times_exactly)
  : pimpl(new pImpl(cycle_msec, times_exactly)) {
}


CycleTimer::~CycleTimer(void) {
}


void CycleTimer::wait(void) {

  size_t now_ticks = GetTicks();
  if (pimpl->next_ticks > now_ticks) {
    size_t delay_msec = pimpl->next_ticks - now_ticks;
    delay(delay_msec);
  }

  pimpl->next_ticks += pimpl->cycle_msec;

  if (! pimpl->times_exactly) {
    // Ԋuێ΂悢ꍇAҋ@ڕWɍɂȂ悤ɂ
    now_ticks = GetTicks();
    while (now_ticks > (pimpl->next_ticks + pimpl->cycle_msec)) {
      pimpl->next_ticks += pimpl->cycle_msec;
    }
  }

}
