#ifndef COMMON_RESOURCES_H
#define COMMON_RESOURCES_H

/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Component.h"
#include "TypingTextConverter.h"
#include <string>

namespace beego {
  class GuiManager;
  class Layer;
  class TtfResource;
  class InputHandler;
  class InputReceiveComponent;
  class ConsolePanelComponent;
  class MusicManager;
  class SoundEffectManager;
};
class TypingRecorder;


/*!
  \brief ʃ\[XǗ
*/
class CommonResources {
  CommonResources(void);
  CommonResources(const CommonResources& rhs);
  CommonResources& operator = (const CommonResources& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

 public:
  beego::GuiManager* gui;       //!< GUI Ǘ
  beego::Layer* front_layer;    //!< OiC[
  beego::Layer* back_layer;     //!< wiC[
  boost::shared_ptr<beego::ConsolePanelComponent> debug;

  beego::Component back_label;  //!< wi摜
  beego::TtfResource* font;     //!< tHg\[X

  beego::InputHandler* input;   //!< ̓nh
  boost::shared_ptr<beego::InputReceiveComponent> input_receiver; //!< ͎M

  beego::MusicManager* music;              //!< wiȂ̊Ǘ
  beego::SoundEffectManager* sound_effect; //!< ʉ̊Ǘ

  TypingTextConverter::ConvertType convert_type; //!< ȕϊ

  TypingRecorder* recorder;     //!< ^CsŐL^
  size_t practice_num;          //!< K
  std::vector<int> waka_order;  //!< â̕

  std::string user_name;        //!< [U

  ~CommonResources(void);

  /*!
    \brief ʃ\[Xւ̊ǗIuWFNgԂ
  */
  static CommonResources* getObject(void);

  /*!
    \brief GUI \[X̏

    \attention XN[ĂĂяoȂ΂ȂȂ
  */
  void initializeGui(void);

  /*!
    \brief tHgf[^邩Ԃ

    \retval true tHgf[^
    \retval false tHgf[^Ȃ
  */
  static bool accessFontData(void);

  /*!
    \brief yf[^邩Ԃ

    \retval true yf[^
    \retval false yf[^Ȃ
  */
  static bool accessMusicData(void);

  /*!
    \brief y̏
  */
  void initializeMusic(void);
};

#endif /* !COMMON_RESOURCES_H */
