/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo ĨXN[[hA[UɋL^ĊǗ
*/

#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "TypingRecorder.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "FillSurface.h"
#include "SdlSurface.h"
#include "TtfResource.h"
#include "TextProperty.h"
#include "ConsolePanelComponent.h"
#include "InputReceiveComponent.h"
#include "LabelComponent.h"
#include "SearchFilePath.h"
#include "back_bmp.h"
#include "CreateSurfaceFromArray.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "ExistFile.h"

using namespace beego;


struct CommonResources::pImpl {
  SDL_Surface* scr;
  Layer debug_layer;
  Surface back_bmp_surface;
  Surface back_surface;
  bool music_initialized;

  pImpl(void) : scr(SDL_GetVideoSurface()), music_initialized(false) {
  }
};


CommonResources::CommonResources(void)
  : pimpl(new pImpl),
    gui(new GuiManager), front_layer(new Layer), back_layer(new Layer),
    music(NULL), sound_effect(NULL),
    convert_type(TypingTextConverter::Roman), recorder(new TypingRecorder),
    practice_num(DefaultPracticeNum),
    //practice_num(1),
    user_name("") {

  gui->push_back(back_layer);
  gui->push_front(front_layer);
  gui->push_front(&pimpl->debug_layer);
}


CommonResources::~CommonResources(void) {

  // !!! ܂AĂ΂邱Ƃ͑z肵ĂȂ񂾂...
  // !!! ̂AK؂ȃ\bhɈړ
  delete music;
  delete sound_effect;
  delete input;
  delete font;
  delete back_layer;
  delete front_layer;
  delete gui;
}


CommonResources* CommonResources::getObject(void) {
  static CommonResources obj;
  return &obj;
}


void CommonResources::initializeGui(void) {

  if (! pimpl->scr) {
    pimpl->scr = SDL_GetVideoSurface();
  }

  // wi摜̏
  Surface new_back_bmp_surface(new SdlSurface(createSurface(back_bmp,
                                                            back_bmp_width,
                                                            back_bmp_height)));
  std::swap(pimpl->back_bmp_surface, new_back_bmp_surface);

  Surface new_back_surface(new FillSurface(pimpl->back_bmp_surface,
                                           pimpl->scr->w, pimpl->scr->h));
  std::swap(pimpl->back_surface, new_back_surface);

  Component new_back_label(new LabelComponent(pimpl->back_surface));
  std::swap(back_label, new_back_label);

  // ͎̏
  font = new TtfResource(FontPath);
  input = new InputHandler;

  boost::shared_ptr<InputReceiveComponent>
    new_input_receiver(new InputReceiveComponent);
  std::swap(input_receiver, new_input_receiver);

  // fobOpl̏
  TextProperty text_property(font, "", SmallSize, Black, Gray4, true);
  boost::shared_ptr<ConsolePanelComponent>
    panel(new ConsolePanelComponent(640, 480, text_property,
                                    ConsolePanelComponent::FadeOut,
                                    ConsolePanelComponent::Up));
  std::swap(debug, panel);

  // R|[lg̔zu
  pimpl->debug_layer.push_front(debug);
  back_layer->push_back(input_receiver);
}


bool CommonResources::accessFontData(void) {

  std::string font_path;
  std::vector<std::string> dir_path;
  if (! searchFilePath(font_path, FontPath, dir_path)) {
    printf("\"%s\" is not found.\n", FontPath);
    return false;
  }
  return true;
}


bool CommonResources::accessMusicData(void) {

  if (existFile(Music1_FilePath) && existFile(Music2_FilePath)) {
    return true;
  } else {
    return false;
  }
}


void CommonResources::initializeMusic(void) {

  if (! pimpl->music_initialized) {

    // IuWFNg̐錾
    music = new MusicManager;
    if (! music->isInitialized()) {
      delete music;
      music = NULL;
      return;
    }
    sound_effect = new SoundEffectManager;

    // Đ
    music->setFadeInEffect(PlayFadeIn);

    // y̏
    music->registerMusic(BackMusic_1, Music1_FilePath);
    music->registerMusic(BackMusic_2, Music2_FilePath);

    sound_effect->registerEffect(SoundEffect_1, Effect1_FilePath);
    sound_effect->registerEffect(SoundEffect_2, Effect2_FilePath);

    sound_effect->registerEffect(Decide, Decide_FilePath);
    sound_effect->registerEffect(Miss, Miss_FilePath);
    // !!!

    pimpl->music_initialized = true;
  }
}
