package jp.sourceforge.htmlconv;

import java.io.*;
import java.util.*;
import java.util.zip.*;

public class HTMLWriter extends BufferedWriter {

	public HTMLWriter(Writer w) {
		super(w);
	}

	/**
	 *
	 */
	public void setFileNameBase(String fname) {
		fileNameBase = fname;
	}

	/**
	 * w肵y[Wo͂܂B
	 * @param page 0`
	 */
	public void writeDocument(Document doc, int page) throws IOException {
		writeHTMLHeader(doc.getTitle(), doc.getKeyword(), doc.getTextColor()
				, doc.getBackgroundColor(), doc.getStyleFile());
		if (doc.getTotalPage() > 1 || doc.getHomeURL() != null
				|| doc.getIndexURL() != null) {
			write(Sentence.convertString(doc.getTitle(), false));
			writeNaviBar(doc, page, true);
			writePageBar(doc, page, true);
			writeLine("<hr noshade>");
		}
		boolean chapnum = false;
		String chapnumstr = doc.getChapterNum();
		if (chapnumstr != null && chapnumstr.equals("on")) chapnum = true;
		writeChapter(doc, 1, page, chapnum);
		if (doc.getTotalPage() > 1 || doc.getHomeURL() != null
				|| doc.getIndexURL() != null) {
			writeLine("<hr noshade>");
			write(Sentence.convertString(doc.getTitle(), false));
			writeNaviBar(doc, page, false);
			writePageBar(doc, page, false);
		}
		writeHTMLFooter();
	}

	/**
	 *
	 */
	public void writeNaviBar(Document doc, int page, boolean key)
			throws IOException {
		write("[ ");
		if (doc.getHomeURL() != null) {
			write("<a href=\"" + doc.getHomeURL() + "\"");
			if (key) write(" accesskey=\"h\"");
			write(">z[(H)</a>");
			write(" | ");
		}
		if (doc.getIndexURL() != null) {
			write("<a href=\"" + doc.getIndexURL() + "\"");
			if (key) write(" accesskey=\"u\"");
			write(">(U)</a>");
			write(" | ");
		}
		if (page == 0) {
			write("O(P)");
		}
		else {
			String fname = getFileName(page - 1);
			write("<a href=\"" + fname + "\"");
			if (key) write(" accesskey=\"p\"");
			write(">O(P)</a>");
		}
		write(" | ");
		if (page == doc.getTotalPage() - 1) {
			write("(N)");
		}
		else {
			String fname = getFileName(page + 1);
			write("<a href=\"" + fname + "\"");
			if (key) write(" accesskey=\"n\"");
			write(">(N)</a>");
		}
		write(" ] " + (page + 1) + "/" + doc.getTotalPage() + "y[W");
		writeLine("<br>");
	}

	/**
	 * Sy[Wւ̃No[
	 */
	public void writePageBar(Document doc, int page, boolean key)
			throws IOException {
		if (doc.getTotalPage() == 1) return;
		write("[ ");
		for (int j = 0; j < doc.getTotalPage(); j++) {
			if (j == page) {
				write(Integer.toString(j + 1) + " ");
				continue;
			}
			String fname = getFileName(j);
			write("<a href=\"" + fname + "\"");
			if (key) write(" accesskey=\"n\"");
			write(">");
			write(Integer.toString(j + 1));
			write("</a> ");
		}
		write(" ]<br>");
	}

	/**
	 *
	 */
	public void writeIndex(Chapter chapter, int level, int page
			, boolean chapnum) throws IOException {
		if (level == 1) {
			//writeLine("<h1>" + chapter.getTitle() + "</h1>");
		}
		else if (level == 2) {
			writeH(chapter, level, true, page, chapnum);
		}
		else {
			String fname = getFileName(chapter.getPage());
			String currentFileName = getFileName(page);
			if (fname.equals(currentFileName)) {
				fname = "";
			}
			write("<p><a href=\"" + fname + "#" + chapter.getKey() + "\">");
			if (chapnum) write(chapter.getNumString() + " ");
			write(Sentence.convertString(chapter.getTitle()));
			writeLine("</a>");
		}
		Vector vect = chapter.getChildTable();
		Iterator ite = vect.iterator();
		while (ite.hasNext()) {
			Object obj = ite.next();
			if (obj instanceof Chapter) {
				Chapter child = (Chapter)obj;
				// ċA
				writeIndex(child, level + 1, page, chapnum);
			}
		}
	}

	/**
	 *
	 */
	public void writeChapter(Chapter chapter, int level, int page
			, boolean chapnum) throws IOException {
		if (page == chapter.getPage()) {
			writeH(chapter, level, false, page, chapnum);
		}
		Vector vect = chapter.getChildTable();
		Iterator ite = vect.iterator();
		while (ite.hasNext()) {
			Object obj = ite.next();
			if (obj instanceof Chapter) {
				Chapter child = (Chapter)obj;
				if (child.getPage() > page) break;
				// ċA
				writeChapter(child, level + 1, page, chapnum);
			}
			else if (chapter.getPage() != page) {
				continue;
			}
			else if (obj instanceof Sentence) {
				// ȀꍇA<br>̕ǂ̂?
				// ݂<p>Aŏo͂ĂB
				Sentence sentence = (Sentence)obj;
				writeP(sentence.getHTMLString());
			}
			else if (obj instanceof List) {
				writeList((List)obj, 0);
			}
			else if (obj instanceof Table) {
				writeTable((Table)obj);
			}
			else if (obj instanceof Code) {
				writeCode((Code)obj);
			}
			else if (obj instanceof HTML) {
				writeHTML((HTML)obj);
			}
			else if (obj instanceof NextPage) {
				writeNextPage((NextPage)obj);
			}
			else if (obj instanceof Index) {
				writeIndex(chapter, 1, page, chapnum);
			}
		}
	}

	/**
	 *
	 */
	public void writeTable(Table table) throws IOException {
		write("<table border=\"1\" summary=\"1\">");
		Iterator ite = table.getRows().iterator();
		while (ite.hasNext()) {
			Vector row = (Vector)ite.next();
			Iterator ite2 = row.iterator();
			write("<tr>");
			while (ite2.hasNext()) {
				Sentence cell = (Sentence)ite2.next();
				write("<td>");
				write(cell.getHTMLString());
				write("</td>");
			}
			writeLine("</tr>");
		}
		write("</table>");
	}

	/**
	 * @level 0`
	 */
	public void writeList(List list, int level) throws IOException {
		if (level > 0) {
			write("<li>");
			writeLine(list.getSentence().getHTMLString());
		}
		Iterator ite = list.getChildTable().iterator();
		if (ite.hasNext()) {
			write("<ul type=\"");
			write((level == 0 ? "disc" : "circle"));
			write("\">");
			while (ite.hasNext()) {
				List child = (List)ite.next();
				writeList(child, level + 1);
			}
			write("</ul>");
		}
	}

	/**
	 *
	 */
	public void writeCode(Code code) throws IOException {
		writeLine("<pre>");
		Vector lines = code.getLines();
		Iterator ite = lines.iterator();
		while (ite.hasNext()) {
			String line = (String)ite.next();
			writeCodeLine(line);
		}
		writeLine("</pre>");
	}

	/**
	 *
	 */
	public void writeHTML(HTML html) throws IOException {
		Vector lines = html.getLines();
		Iterator ite = lines.iterator();
		while (ite.hasNext()) {
			String line = (String)ite.next();
			writeLine(line);
		}
	}

	/**
	 *
	 */
	public void writeNextPage(NextPage nextPage) throws IOException {
		/*
		writeLine("<div class=\"nextpage\">");
		*/
	}

	/**
	 * @param level 1`6
	 */
	public void writeH(Chapter chapter, int level, boolean indexFlag, int page
			, boolean chapnum) throws IOException {
		String fname = getFileName(chapter.getPage());
		String currentFileName = getFileName(page);
		if (fname.equals(currentFileName)) {
			fname = "";
		}
		if (level > 1) write("<br>");
		write("<span class=\"h" + level + "\"><b>");
		if (indexFlag) {
			write("<a href=\"" + fname + "#" + chapter.getKey() + "\">");
		}
		else {
			write("<a name=\"" + chapter.getKey() + "\">");
		}
		if (chapnum) write(chapter.getNumString() + " ");
		else {
			switch (level) {
			case 3:
				write("");
				break;
			case 4:
				write("");
				break;
			case 5:
				write("E");
				break;
			case 6:
				write("- ");
				break;
			}
		}
		write(Sentence.convertString(chapter.getTitle()));
		if (indexFlag) write("</a>");
		writeLine("</a></b></span><br>");
	}

	public String getFileName(int page) {
		if (page == 0) {
			return fileNameBase + ".html";
		}
		else {
			return fileNameBase + "_" + (page + 1) + ".html";
		}
	}

	/**
	 *
	 */
	public void writeP(String text) throws IOException {
		if (!text.startsWith("@")) text = "@" + text;
		writeLine("<div class=\"p\">" + text + "</div>");
	}

	public void writeHTMLHeader(String title, String keywords
			, String textcolor, String bgcolor, String styleFile)
			throws IOException {
		writeLine("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
		writeLine("<html lang=\"ja\">");
		writeLine("<head>");

		// ^Cg
		if (title != null) {
			write("<title>");
			write(Sentence.convertString(title, false));
			writeLine("</title>");
		}

		// R[h̎w
		writeLine("<meta http-equiv=\"Content-Type\" "
				+ "content=\"text/html; charset=Shift_JIS\">");

		// pL[[h
		if (keywords != null) {
			write("<meta name=\"Keywords\" content=\"");
			write(keywords);
			writeLine("\">");
		}

		// X^CV[g
		if (styleFile == null) {
			writeLine("<style type=\"text/css\">");
			writeLine("<!--");
			writeStyleSheet(textcolor, bgcolor);
			writeLine("-->");
			writeLine("</style>");
		}
		else {
			writeLine("<link rel=\"stylesheet\" href=\"" + styleFile
					+ "\" type=\"text/css\">");
		}

		writeLine("</head>");
		writeLine("<body class=\"page-style\">");
		writeLine("<table width=\"600\" summary=\"main\"><tr><td>");
	}

	/**
	 * X^CV[g
	 */
	public void writeStyleSheet(String textcolor, String bgcolor)
			throws IOException {
		// <table>
		writeLine(".page-style {");
		if (textcolor != null) writeLine("\tcolor: " + textcolor + ";");
		if (bgcolor != null) writeLine("\tbackground-color: " + bgcolor + ";");
		//writeLine("\tbackground-image: URL('wowo.jpg');");
		//writeLine("\tbackground-repeat: repeat;");
		//writeLine("\tbackground-repeat: no-repeat;");
		//writeLine("\tbackground-repeat: repeat-x;");
		//writeLine("\tbackground-repeat: repeat-y;");
		writeLine("}");

		// <table>
		writeLine("table {");
		writeLine("\tborder-collapse: collapse;");
		writeLine("\tmargin-left: 26;");
		writeLine("\tmargin-top: 8;");
		writeLine("\tmargin-bottom: 8;");
		writeLine("\tborder-width: 1px;");
		if (textcolor != null) {
			writeLine("\tborder-color: " + textcolor + ";");
		}
		writeLine("}");

		// <td>
		writeLine("td {");
		if (textcolor != null) {
			writeLine("\tborder-color: " + textcolor + ";");
		}
		writeLine("}");

		// <p>
		writeLine(".p {");
		writeLine("\tmargin-top: 4;");
		writeLine("\tmargin-left: 10;");
		// ̂ق
		//writeLine("\ttext-align: justify;");
		writeLine("\ttext-align: left;");
		// ŏ̍}[W͑SpXy[Xgp悤ɕύX
		//writeLine("\ttext-indent: 16;");
		writeLine("\tfont-family: 'lr ','ז';");
		writeLine("\tline-height: 1.5;");
		writeLine("\twidth: 600;");
		writeLine("}");

		// <ul>
		writeLine("ul {");
		writeLine("\tmargin-top: 4;");
		writeLine("\tmargin-bottom: 14;");
		//writeLine("\tmargin-left: 14;");
		//writeLine("\tline-height: 1.5;");
		//writeLine("\twidth: 500;");
		writeLine("}");

		// <li>
		writeLine("li {");
		writeLine("\tmargin-top: 0;");
		writeLine("\tmargin-bottom: 0;");
		writeLine("}");

		// <h1>
		writeLine(".h1 {");
		writeLine("\tfont-size: 28px;");
		writeLine("\tfont-weight: bold;");
		writeLine("\tline-height: 1.5em;");
		//writeLine("\tmargin-bottom: 0;");
		// F͔]
		if (bgcolor != null) {
			writeLine("\tcolor: " + bgcolor + ";");
			writeLine("\tborder-color: " + bgcolor + ";");
		}
		if (textcolor != null) {
			writeLine("\tbackground-color: " + textcolor + ";");
		}
		writeLine("\tborder-width: 1px;");
		writeLine("\twidth: 600;");
		writeLine("}");

		// <h2>
		writeLine(".h2 {");
		writeLine("\tfont-weight: bold;");
		//writeLine("\tmargin-bottom: 0;");
		writeLine("\tfont-size: 22px;");
		writeLine("\twidth: 600;");
		writeLine("\tborder-style: solid;");
		writeLine("\tborder-top-width: 0px;");
		writeLine("\tborder-bottom-width: 1px;");
		writeLine("\tborder-left-width: 0px;");
		writeLine("\tborder-right-width: 0px;");
		writeLine("}");

		// <h3>
		writeLine(".h3 {");
		writeLine("\tfont-weight: bold;");
		//writeLine("\tmargin-bottom: 0;");
		writeLine("\tfont-size: 16px;");
		writeLine("}");

		// <h4>
		writeLine(".h4 {");
		writeLine("\tfont-weight: bold;");
		//writeLine("\tmargin-bottom: 0;");
		writeLine("\tfont-size: 16px;");
		writeLine("}");

		// <h5>
		writeLine(".h5 {");
		writeLine("\tfont-weight: bold;");
		//writeLine("\tmargin-bottom: 0;");
		writeLine("\tfont-size: 16px;");
		writeLine("}");

		// <h6>
		writeLine(".h6 {");
		writeLine("\tfont-weight: bold;");
		//writeLine("\tmargin-bottom: 0;");
		writeLine("\tfont-size: 16px;");
		writeLine("}");

		// <pre>
		writeLine("pre {");
		writeLine("\tmargin-left: 40;");
		writeLine("\tfont-family: 'lr SVbN','SVbN';");
		writeLine("}");

		// nextpage
		writeLine(".nextpage {");
		writeLine("\tpage-break-before: always;");
		writeLine("}");
	}

	private void writeHTMLFooter() throws IOException {
		writeLine("</td></tr></table>");
		write("</body>");
		newLine();
		write("</html>");
		newLine();
	}

	/**
	 *
	 */
	public void writeCodeLine(String text) throws IOException {
		char[] chbuf = text.toCharArray();
		StringBuffer strbuf = new StringBuffer();
		for (int j = 0; j < chbuf.length; j++) {
			if (chbuf[j] == '\t') {
				// TAB͋4Ƃ(b)
				strbuf.append("    ");
			}
			else if (chbuf[j] == '<') {
				strbuf.append("&lt;");
			}
			else if (chbuf[j] == '>') {
				strbuf.append("&gt;");
			}
			else if (chbuf[j] == '&') {
				strbuf.append("&amp;");
			}
			else {
				strbuf.append(chbuf[j]);
			}
		}
		writeLine(new String(strbuf));
	}

	/**
	 *
	 */
	public void writeLine(String line) throws IOException {
		write(line);
		newLine();
	}

	/**
	 *
	 */
	private String fileNameBase;

}
