package jp.sourceforge.htmlconv;

import java.io.*;
import java.util.*;

/**
 * eLXgHTMLϊvg^CvvOB
 * ܂ȃC[Wł܂A@\NXɕčĐ݌vB
 *
 * @author OHASHI Hideya
 */
public class Conv {

	/**
	 *
	 */
	public void convert(String fname) throws IOException {
		File infile = new File(fname);
		Reader fileReader = new InputStreamReader(new FileInputStream(fname)
				, "JISAutoDetect");
		try {
			BufferedReader bufReader = new BufferedReader(fileReader);
			while (true) {
				String line = bufReader.readLine();
				if (line == null) break;
				if (line.startsWith("!include ")) {
					String target = line.substring(9);
					if (infile.getParent() != null) {
						target = infile.getParent() + File.separator
								+ target;
					}
					convert(target);
					continue;
				}
				else {
					convertLine(line);
				}
			}
		}
		finally {
			fileReader.close();
		}
	}

	/**
	 *
	 */
	public void convertLine(String line) throws IOException {
		switch (phase) {
		case PH_HEAD:
			convertHead(line);
			break;
		case PH_BODY:
			convertBody(line);
			break;
		case PH_CODE:
			convertCode(line);
			break;
		case PH_HTML:
			convertHTML(line);
			break;
		case PH_TABLE:
			convertTable(line);
			break;
		case PH_LIST:
			convertList(line);
			break;
		}
	}

	/**
	 *
	 */
	public void convertHead(String line) throws IOException {
		// ^Cg
		if (line.startsWith("#")) {
			document.setTitle(line.substring(1));
		}
		// {bgpL[[h
		else if (line.startsWith("!keyword")) {
			document.setKeyword(line.substring(9));
		}
		// F
		else if (line.startsWith("!text")) {
			document.setTextColor(line.substring(6));
		}
		// wiF
		else if (line.startsWith("!bg")) {
			document.setBackgroundColor(line.substring(4));
		}
		// z[̎w
		else if (line.startsWith("!home")) {
			document.setHomeURL(line.substring(6));
		}
		// 1Kw̎w
		else if (line.startsWith("!up")) {
			document.setIndexURL(line.substring(4));
		}
		// ͔ԍ̗L
		else if (line.startsWith("!chapternum")) {
			document.setChapterNum(line.substring(12));
		}
		// X^CV[g
		else if (line.startsWith("!style")) {
			document.setStyleFile(line.substring(7));
		}
		// {̊Jn
		else if (line.startsWith("!body") || line.equals("!")) {
			phase = PH_BODY;
		}
	}

	/**
	 *
	 */
	public void convertBody(String line) throws IOException {
		// os
		if (line.startsWith("#")) {
			paraflag = false;
			// cnt1ȏƂȂ
			int cnt = countStartCharLength(line);
			counts[cnt - 1]++;
			counts[cnt] = 0;
			Chapter newChapter = new Chapter();
			newChapter.setTitle(line.substring(cnt));
			newChapter.setNumber(counts[cnt - 1]);
			int num = chapterLevel - cnt + 1;
			for (int j = 0; j < num; j++) {
				currentChapter = currentChapter.getParentChapter();
			}
			newChapter.setParentChapter(currentChapter);
			newChapter.setPage(document.getTotalPage() - 1);
			currentChapter.addChapter(newChapter);
			currentChapter = newChapter;
			chapterLevel = cnt;
		}
		// ӏ
		else if (line.startsWith("- ")) {
			paraflag = false;
			phase = PH_LIST;
			List parentList = new List(null);
			currentList = parentList.newChildList(
					new Sentence(line.substring(2)));
			currentChapter.addList(parentList);
		}
		// R[h̊Jn
		else if (line.startsWith("!code")) {
			paraflag = false;
			phase = PH_CODE;
			currentCode = new Code();
			currentChapter.addCode(currentCode);
		}
		// HTML̊Jn
		else if (line.startsWith("!html")) {
			paraflag = false;
			phase = PH_HTML;
			currentHTML = new HTML();
			currentChapter.addHTML(currentHTML);
		}
		// \̊Jn
		else if (line.startsWith("!table")) {
			paraflag = false;
			phase = PH_TABLE;
			// s؂w
			int pos = line.indexOf("rowsepa=\"");
			if (pos > 0) {
				// "rowsepa=\"".length() == 9
				rowSepa = line.substring(pos + 9);
				pos = rowSepa.indexOf("\"");
				rowSepa = rowSepa.substring(0, pos);
			}
			// ؂w
			pos = line.indexOf("colsepa=\"");
			if (pos > 0) {
				// "colsepa=\"".length() == 9
				colSepa = line.substring(pos + 9);
				pos = colSepa.indexOf("\"");
				colSepa = colSepa.substring(0, pos);
			}
			currentTable = new Table();
			currentChapter.addTable(currentTable);
		}
		// y[W
		else if (line.startsWith("!nextpage")) {
			currentChapter.addNextPage(new NextPage());
			// y[W
			document.addTotalPage();
		}
		// ڎ
		else if (line.startsWith("!index")) {
			currentChapter.addIndex(new Index());
		}
		// 
		else if (line.length() > 0) {
			currentChapter.addSentence(new Sentence(line));
			if (!paraflag) {
				paraflag = true;
			}
		}
	}

	/**
	 *
	 */
	public void convertCode(String line) throws IOException {
		if (line.equals("!")) {
			phase = PH_BODY;
			currentCode = null;
		}
		else {
			currentCode.addLine(line);
		}
	}

	/**
	 *
	 */
	public void convertHTML(String line) throws IOException {
		if (line.equals("!")) {
			phase = PH_BODY;
			currentHTML = null;
		}
		else {
			currentHTML.addLine(line);
		}
	}

	/**
	 *
	 */
	public void convertTable(String line) throws IOException {
		if (line.equals("!")) {
			phase = PH_BODY;
			if (rowSepa != null) {
				if (colFlag == false) {
				}
				if (rowFlag == false) {
				}
			}
			rowSepa = null;
			colSepa = null;
			rowFlag = true;
			colFlag = true;
			currentTable = null;
		}
		else {
			if (rowSepa == null && colSepa == null) {
				currentTable.addRow();
				StringTokenizer tknr = new StringTokenizer(line
						, "\t");
				while (tknr.hasMoreTokens()) {
					String tkn = tknr.nextToken();
					currentTable.addCell(new Sentence(tkn));
				}
			}
			else {
				if (line.equals(rowSepa)) {
					if (colFlag == false) {
						colFlag = true;
					}
					if (rowFlag == false) {
						rowFlag = true;
					}
				}
				else if (line.equals(colSepa)) {
					if (colFlag == false) {
						colFlag = true;
					}
				}
				else {
					if (rowFlag) {
						rowFlag = false;
						currentTable.addRow();
					}
					if (colFlag) {
						colFlag = false;
						currentTable.addCell(new Sentence(line));
					}
					else {
						// sɂ܂ꍇ
						Sentence sentence = currentTable.getLastCell();
						sentence.addText(line);
					}
				}
			}
		}
	}

	/**
	 *
	 */
	public void convertList(String line) throws IOException {
		int lpos = line.indexOf("- ");
		if (lpos < 0) {
			phase = PH_BODY;
			currentList = null;
			listLevel = 0;
			convertBody(line);
		}
		else {
			int count = listLevel - lpos + 1;
			for (int j = 0; j < count; j++) {
				currentList = currentList.getParent();
			}
			listLevel = lpos;
			currentList = currentList.newChildList(
					new Sentence(line.substring(lpos + 2)));
		}
	}

	/**
	 * line ̐擪 "#" ̕𐔂ĕԂ܂B
	 */
	private int countStartCharLength(String line) {
		int j = 0;
		for (; j < line.length(); j++) {
			if (line.charAt(j) != '#') break;
		}
		return j;
	}

	private Document document = new Document();
	private int phase = PH_HEAD;

	/**
	 * i̘A<p>łȂ<br>ɂ邽
	 */
	private boolean paraflag = false;

	private int[] counts = new int [16];
	private Chapter currentChapter = document;
	private List currentList = null;
	private Table currentTable = null;
	private Code currentCode = null;
	private HTML currentHTML = null;
	private int chapterLevel = 0;

	/**
	 * ӏ̃x
	 */
	private int listLevel = 0;

	private String rowSepa = null;
	private String colSepa = null;
	private boolean rowFlag = true;
	private boolean colFlag = true;

	public static final int PH_HEAD = 0;
	public static final int PH_BODY = 1;
	public static final int PH_CODE = 2;
	public static final int PH_TABLE = 3;
	public static final int PH_LIST = 4;
	public static final int PH_HTML = 5;

	/**
	 *
	 */
	public static void convert(String[] args) {
		if (args.length < 1) {
			System.out.println("usage: [option] {filename...}");
			System.out.println("option: -tex");
			System.exit(0);
		}
		DocBuilder docBuilder = null;
		int startp = 0;
		if (args[0].equals("-tex")) {
			startp = 1;
			docBuilder = new TEXBuilder();
		}
		else {
			docBuilder = new HTMLBuilder();
		}
		for (int j = startp; j < args.length; j++) {
			try {
				String fname = args[j];
				int pos = fname.lastIndexOf(".");
				// name ̓pX܂ށAgq
				String name = fname.substring(0, pos);
				Conv conv = new Conv();
				conv.convert(fname);
				docBuilder.build(conv.document, name);
			}
			catch (Exception x) {
				x.printStackTrace();
			}
		}
	}

	/**
	 *
	 */
	public static void main(String[] args) {
		convert(args);
		System.exit(0);
	}

}
