#!/bin/bash
if [ -z $VERSION ]; then
	echo "please set VERSION"
	echo "ex) export VERSION=0.00"
	exit 1
fi
if [ -z $RPMHOME ]; then
	echo "please set RPMHOME"
	echo "ex) export RPMHOME=~/rpm"
	exit 1
fi

#binary package (windows)
JLAUNCH=jlaunch-0.08.lzh
JINSTALL=jinstall-0.01.lzh
wget -nv -c http://plaza2.mbn.or.jp/~ohac/javalaunch/$JLAUNCH \
		http://plaza2.mbn.or.jp/~ohac/install/$JINSTALL \
		http://www.opensource.jp/gpl/gpl.ja.txt \
		http://www.gnu.org/licenses/gpl.txt
rm -fr release
htmlconv readme.txt
mkdir release
pushd release
cp ../htmlconv.jar .
cp ../setup.inf .
lha x ../$JINSTALL setup.jar
lha x ../$JINSTALL win32jni.dll
lha x ../$JLAUNCH jlaunch.exe
cp ../gpl.txt ../gpl.ja.txt .
cp ../readme.txt ../readme.html ../sample.txt .
rm -f ../htmlconv-$VERSION.lzh
lha ao5 ../htmlconv-$VERSION.lzh *
popd
rm -fr release

#source package
rm -fr htmlconv-$VERSION
mkdir htmlconv-$VERSION
pushd htmlconv-$VERSION
cp ../gpl.txt ../gpl.ja.txt .
cp -R ../src .
rm -fr `find -name CVS -a -type d`
cp ../htmlconv ../htmlconv.1 ../htmlconv.desktop ../htmlconv.mf \
		../htmlconv.spec.sh .
cp ../*.awk ../*.pl ../*.txt ../*.sh ../makefile ../*.inf .
popd
rm -f htmlconv-src-$VERSION.tar.gz
tar zcvf htmlconv-src-$VERSION.tar.gz htmlconv-$VERSION
rm -fr htmlconv-$VERSION

#binary package (linux rpm)
cp -f htmlconv-src-$VERSION.tar.gz $RPMHOME/SOURCES
./htmlconv.spec.sh
rpm -bb htmlconv.spec
mv $RPMHOME/RPMS/noarch/htmlconv-$VERSION-0.noarch.rpm .

#web update (Java Web Start)
if ! [ -z $SFUSER ]; then
	scp htmlconv.jar $SFUSER@shell.sourceforge.jp:/home/groups/h/ht/htmlconv/htdocs
else
	echo "if you have SourceForge.jp ID, and registed SSH public key."
	echo "you can use SFUSER environment."
	echo "Ex) export SFUSER=ohac"
fi
