#!/bin/bash
cat >htmlconv.spec <<EOD
name: htmlconv
Release: 0
Version: $VERSION
Copyright: OHASHI Hideya <ohac@users.sourceforge.jp>
Group: Utilities
BuildArch: noarch
Source: htmlconv-src-$VERSION.tar.gz
Summary: Convert text file to HTML Document.
Packager: OHASHI Hideya <ohac@users.sourceforge.jp>
Distribution: Vine Linux 2.5
BuildRoot: $RPMHOME/ROOT

%description
Convert text file to HTML Document.
Needs Java 2 Runtime Environment.

%prep
rm -rf \$RPM_BUILD_ROOT/*
mkdir -p \$RPM_BUILD_ROOT/usr/bin
mkdir -p \$RPM_BUILD_ROOT/usr/share/man/ja/man1
mkdir -p \$RPM_BUILD_ROOT/usr/share/htmlconv/jars
mkdir -p \$RPM_BUILD_ROOT/etc/X11/applnk/Utilities
mkdir -p \$RPM_BUILD_ROOT/usr/share/gnome/apps/Utilities

%setup

%build
make all
gzip <htmlconv.1 >htmlconv.1.gz

%install
install -s htmlconv.jar \$RPM_BUILD_ROOT/usr/share/htmlconv/jars
install -s htmlconv \$RPM_BUILD_ROOT/usr/bin
install -s htmlconv.1.gz \$RPM_BUILD_ROOT/usr/share/man/ja/man1
install -s htmlconv.desktop \$RPM_BUILD_ROOT/etc/X11/applnk/Utilities
install -s htmlconv.desktop \$RPM_BUILD_ROOT/usr/share/gnome/apps/Utilities

%clean
rm -rf \$RPM_BUILD_ROOT

%files
%attr(-,root,root) /usr/share/htmlconv/jars/htmlconv.jar
%attr(-,root,root) /etc/X11/applnk/Utilities/htmlconv.desktop
%attr(-,root,root) /usr/share/gnome/apps/Utilities/htmlconv.desktop
%attr(-,root,root) /usr/share/man/ja/man1/htmlconv.1.gz
%attr(-,root,root) /usr/bin/htmlconv
EOD
