package jp.or.mbn.plaza2.ohac;

import java.io.*;
import java.util.Vector;
import java.util.Iterator;

/**
 * TeXt@C𐶐邽߂̃NX
 *
 * @author OHASHI Hideya
 */
public class TEXBuilder implements DocBuilder {

	/**
	 * TeXt@C𐶐܂B
	 * @param doc hLgIuWFNg
	 * @param name pX܂ށAgq
	 */
	public void build(Document doc, String name) {
		Writer fileWriter = null;
		try {
			// ftHgR[hŐ
			fileWriter = new OutputStreamWriter(
					new FileOutputStream(name + ".tex"));
			BufferedWriter bufWriter = new BufferedWriter(fileWriter);
			buildTEX(bufWriter, doc);
			bufWriter.flush();
		}
		catch (IOException x) {
			x.printStackTrace();
		}
		finally {
			if (fileWriter != null) {
				try { fileWriter.close(); } catch (Exception x) {}
			}
		}
	}

	private void buildTEX(BufferedWriter bufWriter, Document doc)
			throws IOException {
		//bufWriter.write("\\documentclass [twoside,twocolumn]{jreport}");
		//bufWriter.write("\\documentclass [twoside,twocolumn]{jbook}");
		//bufWriter.write("\\documentclass [twoside,twocolumn]{jarticle}");
		bufWriter.write("\\documentclass {jarticle}");
		bufWriter.newLine();
		bufWriter.write("\\title{" + doc.getTitle() + "}");
		bufWriter.newLine();
		bufWriter.write("\\begin{document}");
		bufWriter.newLine();
		bufWriter.write("\\maketitle");
		bufWriter.newLine();
		writeChapter(bufWriter, doc, 1);
		bufWriter.write("\\end{document}");
		bufWriter.newLine();
	}

	/**
	 *
	 */
	public void writeChapter(BufferedWriter bufWriter, Chapter chapter
			, int level) throws IOException {
		final String[] TYPE = { "part", /*"chapter",*/ "section"
				, "subsection", "subsubsection" };
		if (level >= 2 && level < TYPE.length + 2) {
			bufWriter.write("\\" + TYPE[level - 2] + "{"
					+ chapter.getTitle() + "}");
			bufWriter.newLine();
		}

		Vector vect = chapter.getChildTable();
		Iterator ite = vect.iterator();
		while (ite.hasNext()) {
			Object obj = ite.next();
			if (obj instanceof Chapter) {
				Chapter child = (Chapter)obj;
				// ċA
				writeChapter(bufWriter, child, level + 1);
			}
			else if (obj instanceof Sentence) {
				Sentence sentence = (Sentence)obj;
				//writeP(sentence.getHTMLString());
				bufWriter.write(sentence.getHTMLString());
				bufWriter.newLine();
				bufWriter.newLine();
			}
			else if (obj instanceof NextPage) {
				writeNextPage(bufWriter, (NextPage)obj);
			}
			else if (obj instanceof List) {
				writeList(bufWriter, (List)obj, 0);
			}
			else if (obj instanceof Table) {
				writeTable(bufWriter, (Table)obj);
			}
			/*
			else if (obj instanceof Code) {
				writeCode((Code)obj);
			}
			else if (obj instanceof HTML) {
				writeHTML((HTML)obj);
			}
			else if (obj instanceof Index) {
				writeIndex(chapter, 1, page);
			}
			*/
		}
	}

	private void writeNextPage(BufferedWriter bufWriter, NextPage obj)
			throws IOException {
		bufWriter.write("\\pagebreak");
		bufWriter.newLine();
	}

	/**
	 * @level 0`
	 */
	public void writeList(BufferedWriter bufWriter, List list, int level)
			throws IOException {
		if (level > 0) {
			bufWriter.write("\\item ");
			bufWriter.write(list.getSentence().getHTMLString());
			bufWriter.newLine();
		}
		Iterator ite = list.getChildTable().iterator();
		if (ite.hasNext()) {
			bufWriter.write("\\begin{itemize}");
			bufWriter.newLine();
			while (ite.hasNext()) {
				List child = (List)ite.next();
				writeList(bufWriter, child, level + 1);
			}
			bufWriter.write("\\end{itemize}");
			bufWriter.newLine();
		}
	}

	/**
	 *
	 */
	public void writeTable(BufferedWriter bufWriter, Table table)
			throws IOException {
// debug!!!
//		bufWriter.write("\\begin{tabular}{|p{10cm}|l|l|l|l|}");
		bufWriter.write("\\begin{tabular}{|l|l|l|l|l|}");
		bufWriter.newLine();
		Iterator ite = table.getRows().iterator();
		while (ite.hasNext()) {
			Vector row = (Vector)ite.next();
			Iterator ite2 = row.iterator();
			bufWriter.write("\\hline");
			bufWriter.newLine();
			while (ite2.hasNext()) {
				Sentence cell = (Sentence)ite2.next();
				bufWriter.write(cell.getHTMLString());
				bufWriter.write((ite2.hasNext() ? " & " : " \\\\"));
			}
			bufWriter.newLine();
		}
		bufWriter.write("\\hline");
		bufWriter.newLine();
		bufWriter.write("\\end{tabular}");
		bufWriter.newLine();
	}

}
