package jp.or.mbn.plaza2.ohac;

import java.io.*;

/**
 * HTMLt@C𐶐邽߂̃NX
 *
 * @author OHASHI Hideya
 */
public class HTMLBuilder implements DocBuilder {

	/**
	 * HTMLt@CƃX^CV[g𐶐܂B
	 * @param doc hLgIuWFNg
	 * @param name pX܂ށAgq
	 */
	public void build(Document doc, String name) {
		// namebase ̓pXAgq
		String namebase = name;
		int pos = name.lastIndexOf(File.separator);
		if (pos >= 0) {
			namebase = name.substring(pos + 1);
		}
		// ey[W𐶐
		for (int k = 0; k < doc.getTotalPage(); k++) {
			String outfname = null;
			if (k == 0) {
				outfname = name + ".html";
			}
			else {
				outfname = name + "_" + (k + 1) + ".html";
			}
			// 1y[W\z
			buildHTML(doc, outfname, k, namebase);
		}
		// X^CV[gΐ
		buildStyleSheet(doc);
	}

	/**
	 * HTML𐶐܂B
	 * @param doc hLgIuWFNg
	 * @param outfname o̓t@C
	 * @param page y[W(0..*)
	 */
	private void buildHTML(Document doc, String outfname
			, int page, String namebase) {
		Writer fileWriter = null;
		try {
			fileWriter = new OutputStreamWriter(
					new FileOutputStream(outfname), "SJIS");
			HTMLWriter bufWriter = new HTMLWriter(fileWriter);
			bufWriter.setFileNameBase(namebase);
			// 1y[W\z
			bufWriter.writeDocument(doc, page);
			bufWriter.flush();
		}
		catch (IOException x) {
			x.printStackTrace();
		}
		finally {
			if (fileWriter != null) {
				try { fileWriter.close(); } catch (Exception x) {}
			}
		}
	}

	/**
	 * X^CV[gΐ
	 * @param doc hLgIuWFNg
	 */
	private void buildStyleSheet(Document doc) {
		String stylefile = doc.getStyleFile();
		if (stylefile == null) return;
		if ((new File(stylefile)).exists()) return;
		Writer fileWriter = null;
		try {
			fileWriter = new OutputStreamWriter(
					new FileOutputStream(stylefile), "SJIS");
			HTMLWriter bufWriter = new HTMLWriter(fileWriter);
			bufWriter.writeStyleSheet(doc.getTextColor()
					, doc.getBackgroundColor());
			bufWriter.flush();
			bufWriter.close();
		}
		catch (IOException x) {
			x.printStackTrace();
		}
		finally {
			if (fileWriter != null) {
				try { fileWriter.close(); } catch (Exception x) {}
			}
		}
	}

}

