package jp.or.mbn.plaza2.ohac;

import java.io.*;
import java.util.List;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import javax.swing.*;

/**
 *
 */
public class ConvDlg extends JApplet implements DropTargetListener {

	/**
	 *
	 */
	public ConvDlg() {
		// Drag&DropΉ
		DropTarget dnd = new DropTarget(output, this);

		// o[W\
		output.append("HTML Converter Ver." + Version.VERSION + "\n");
		output.append("ɃhbOAhhbvĂB\n");

		Container cpane = getContentPane();

		// 
		cpane.add(output, BorderLayout.CENTER);
		output.setPreferredSize(new Dimension(400, 200));

		// 
		JPanel pnl = new JPanel(new BorderLayout());
		pnl.add(pathField, BorderLayout.CENTER);
		// ̉E
		JPanel pnl2 = new JPanel();
		// Q
		JButton btn = new JButton("Q...");
		btn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectFile();
			}
		});
		pnl2.add(btn);
		// ϊ
		btn = new JButton("ϊ");
		btn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				convertFile();
			}
		});
		pnl2.add(btn);
		// TeX[h
		pnl2.add(texCheckBox);
		pnl.add(pnl2, BorderLayout.EAST);
		cpane.add(pnl, BorderLayout.SOUTH);
	}

	public void dragEnter(DropTargetDragEvent ev) {
	}

	public void dragExit(DropTargetEvent ev) {
	}

	public void dragOver(DropTargetDragEvent ev) {
	}

	public void drop(DropTargetDropEvent ev) {
		Transferable trns = ev.getTransferable();
		if (trns.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
			ev.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			try {
				List list = (List)trns.getTransferData(DataFlavor.javaFileListFlavor);
				for (Iterator it = list.iterator(); it.hasNext(); ) {
					File file = (File)it.next();
					pathField.setText(file.getAbsolutePath());
					convertFile();
				}
			}
			catch (Exception x) {
				output.append("ϊs " + x + "\n");
				x.printStackTrace();
			}
			ev.dropComplete(true);
		}
	}

	public void dropActionChanged(DropTargetDragEvent ev) {
	}


	/**
	 *
	 */
	private void selectFile() {
		JFileChooser filedlg = new JFileChooser();
		filedlg.setCurrentDirectory(new File("."));
		int returnVal = filedlg.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			pathField.setText(filedlg.getSelectedFile().getPath());
			convertFile();
		}
	}

	/**
	 *
	 */
	private void convertFile() {
		boolean texMode = texCheckBox.isSelected();
		String[] paths = new String [texMode ? 2 : 1];
		int pos = 0;
		if (texMode) {
			paths[pos] = "-tex";
			pos++;
		}
		paths[pos] = pathField.getText();
		output.append("ϊ(" + (texMode ? "TeX" : "HTML") + ")... "
				+ paths[pos] + "\n");
		Conv.convert(paths);
		output.append("ϊ\n");
	}

	/**
	 *
	 */
	private static void exit() {
		System.exit(0);
	}

	/**
	 *
	 */
	private JTextField pathField = new JTextField();

	/**
	 *
	 */
	private JTextArea output = new JTextArea();

	/**
	 *
	 */
	private JCheckBox texCheckBox = new JCheckBox("TeX[h");

	/**
	 *
	 */
	public static void main(String[] args) {
		final JFrame frame = new JFrame("HTMLϊt@CI");
		ConvDlg dlg = new ConvDlg();
		frame.getContentPane().add(dlg);

		// I
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				exit();
			}
		});
		frame.pack();
		frame.show();

/*
		// j[
		JMenuBar menubar = new JMenuBar();
		setJMenuBar(menubar);
		JMenu menu = new JMenu("t@C");

		// J
		JMenuItem menuitem = new JMenuItem("J...");
		menuitem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectFile();
			}
		});
		menu.add(menuitem);

		// ϊ
		menuitem = new JMenuItem("ϊ");
		menuitem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				convertFile();
			}
		});
		menu.add(menuitem);
		menu.add(new JSeparator());

		// I
		menuitem = new JMenuItem("I");
		menuitem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				exit();
			}
		});
		menu.add(menuitem);
		menubar.add(menu);
*/
	}

}
