#include "server.h"
#include "shead.h"

static const char* id = NULL;

static BOOL
checkCommon(HTLIB_HANDLE h,
			HTLIB_Header* hh, short hlen, const char* ua)
{
	HTLIB_ERROR err = 0;
	
	if (ua == NULL) {
		ua = "testc/1.0";
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "User-Agent"))==-1) {
		FAIL(id, "no User-Agent");
		return FALSE;
	}
	if (strcmp(hh[i].value, ua)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, ua);
		return FALSE;
	}
	return TRUE;
}
static BOOL
checkHost(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, const char* host)
{
	int i;
	HTLIB_ERROR err = 0;
	
	if (host == NULL) {
		host = "localhost:8000";
	}
	if ((i=HTLIB_Find(hh, hlen, "Host"))==-1) {
		FAIL(id, "no Host");
		return FALSE;
	}
	if (strcmp(hh[i].value, host)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, host);
		return FALSE;
	}
	return TRUE;
}

static BOOL
test1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, "dummy", 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "dummy", 5, &err)||
		err != HTLIB_E_INVALID_STATE) {
		FAIL(id, "why?");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}

	if (HTLIB_SendBody(h, -1, NULL, 5, &err)||
		err != HTLIB_E_INVALID_STATE) {
		FAIL(id, "why?");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "dummy", 5, &err)||
		err != HTLIB_E_INVALID_STATE) {
		FAIL(id, "why?");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test3(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 404, NULL, &resh, 1, NULL, 6,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}

	if (HTLIB_SendBody(h, -1, "err404", 6, &err)||
		err != HTLIB_E_INVALID_STATE) {
		FAIL(id, "why?");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test4sub(HTLIB_HANDLE h,
		 HTLIB_Header* hh, short hlen, int seq, const char* body)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Length", "5")==FALSE) {
		return FALSE;
	}

	char cseq[8];
	sprintf(cseq, "%d", seq);
	HTLIB_Header resh[] = {
		{ "Content-Type", "application/octet-stream", 0, NULL, },
		{ "X-Body", body, 0, NULL, },
		{ "X-Seq", cseq, 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}

	if (HTLIB_SendBody(h, -1, body, 5, &err)||
		err != HTLIB_E_INVALID_STATE) {
		FAIL(id, "why?");
		return FALSE;
	}
	return TRUE;
}

static BOOL
test4_1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	if (test4sub(h, hh, hlen, seq, "body1")==FALSE) {
		return FALSE;
	}
	HTLIB_Close(h);
	return TRUE;
}
static BOOL
test4_2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	if (test4sub(h, hh, hlen, seq, "body2")==FALSE) {
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

BOOL
testHead(HTLIB_HANDLE h, const char* uri, const char* method,
		HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	static struct {
		const char* id;
		const char* path;
		BOOL(*func)(HTLIB_HANDLE, HTLIB_Header*, short hlen, int seq);
	} ff[] = {
		{ "HEAD-1(S)", "/head/200", test1 },
		{ "HEAD-2(S)", "/head/chunk", test2 },
		{ "HEAD-3(S)", "/head/404", test3 },
		{ "HEAD-4(S)", "/head/body1", test4_1 },
		{ "HEAD-4(S)", "/head/body2", test4_2 },
	};

	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		if (strcmp(uri, ff[i].path)==0) {
			id = ff[i].id;
			if (strcmp(method, "HEAD")!=0) {
				FAIL(id, "%s must be HEAD", method);
				return FALSE;
			}
			return ff[i].func(h, hh, hlen, seq);
		}
	}

	FAIL("GET-X", "not implemented for %s", uri);
	return FALSE;
}

