#include "server.h"
#include "Session.h"

static volatile BOOL s_exit = FALSE; 

static void
connectAndClose()
{
	int s = socket(PF_INET, SOCK_STREAM, 0);
	if (s==-1) {
		perror("socket");
	}
	struct sockaddr_in a;
	memset(&a, 0, sizeof(a));
	a.sin_family = AF_INET;
	a.sin_port = htons(8000);
	a.sin_addr.s_addr = htonl(0x7f000001);
	if (connect(s, (struct sockaddr*)&a, sizeof(a))==-1) {
		perror("connect");
	}
	printf("connected\n");
	close(s);
}

void
sexit()
{
	s_exit = TRUE;
	connectAndClose();
}

static void
logh(const char* file,
	 int line,
	 HTLIB_LOGLEVEL level,
	 const char* msg)
{
	printf("%s:%d: [lv=%d] %s\n", file, line, level, msg);
}

int
main(int argc, char* argv[])
{
	HTLIB_SetLogHandler(logh);
	HTLIB_SetLogLevel(HTLIB_LV_DEBUG);
	
	int s = socket(PF_INET, SOCK_STREAM, 0);
	if (s == -1) {
		perror("socket");
		return 2;
	}

	int port = 8000;
	
	int on = 1;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))==-1) {
		perror("setsockopt");
		return 3;
	}
	
	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (bind(s, (struct sockaddr*)&addr, sizeof(addr))==-1) {
		perror("bind");
		return 3;
	}
	if (listen(s, 5)==-1) {
		perror("listen");
		return 4;
	}

	printf("%s start to listen on the port %d...\n", argv[0], port);

	int soc;
	struct sockaddr_storage ss;
	pthread_t th;
	socklen_t slen = sizeof(ss);
	while ((soc=accept(s, (struct sockaddr*)&ss, &slen))!=-1) {
		if (s_exit) {
			break;
		}
		if ((errno=pthread_create(&th, NULL, doSession, (void*)soc))!=0) {
			perror("pthread_create");
			return 5;
		}
		pthread_detach(th);
	}

	sleep(3);
	
	return 6;
}
