#include "test.h"
#include "cget.h"
#include "chead.h"
#include "cpost.h"
#include "chttp.h"
#include "cmisc.h"

static void
logh(const char* file,
	 int line,
	 HTLIB_LOGLEVEL level,
	 const char* msg)
{
	printf("%s:%d: [lv=%d] %s\n", file, line, level, msg);
}

int
main(int argc, char* argv[])
{
	HTLIB_BOOL toExit = 0;
	HTLIB ht;
	HTLIB_HANDLE h = &ht;
	HTLIB_ERROR err;

	char send_buffer[1024];
	char rec_buffer[1024];

	if (argc>1 && strcmp(argv[1], "exit")==0) {
		toExit =1;
	}
	HTLIB_SetLogHandler(logh);
	HTLIB_SetLogLevel(HTLIB_LV_DEBUG);
	
	if (HTLIB_Init(h,
				   send_buffer, sizeof(send_buffer),
				   rec_buffer, sizeof(rec_buffer),
				   &err)==FALSE) {
		printf("HTLIB_Init failed err=%d:%s\n",
				err, HTLIB_GetErrorMessage(err));
		return 2;
	}

	h->agent_or_server_name = "testc/1.0";

	testMisc(h);
	testGet(h);
	testHead(h);
	testPost(h);
	testHttp(h);

	if (toExit) {
		sleep(2);
		HTLIB_SendRequest(h, -1, "GET", URLBASE "/exit",
						  NULL, 0, NULL, 0, &err);
		HTLIB_Close(h);
		HTLIB_SendRequest(h, -1, "GET", URLBASE "/exit",
						  NULL, 0, NULL, 0, &err);
		HTLIB_Close(h);
	}
	HTLIB_Uninit(h);
	return 0;
}
