<?php
// mycssadmin ver 1.0.4
//  ------------------------------------------------------------------------ //
//                   This module; Copyright (c) 2005 gusagi                  //
//                        <http://good-tea.ddo.jp/dev>                       //
//  ------------------------------------------------------------------------ //

//*****************************************************************************/ 
// ľܸƤӽФ줿exit
//*****************************************************************************/ 
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

if( ! class_exists( 'MyCssAdmin' ) ) {

class MyCssAdmin {

	var $blocks = array();
	var $del_blocks = array();

	/**
	 * MyCssAdmin
	 * 
	 * @param void
	 * @return void
	 */
	function MyCssAdmin() {
	}

	/**
	 * setBlockList
	 * 
	 * @param $mid
	 * @return void
	 */
	function setBlockList( $mid ) {
		// 
		$mid = intval( $mid );
		$xoopsDB =& Database::getInstance();
		$sql = '';
		$newblocks = $xoopsDB->prefix( 'newblocks' );
		include_once( XOOPS_ROOT_PATH.'/class/xoopsblock.php' ) ;
		// ֥åμ
		$sql = "SELECT * FROM $newblocks";
		$sql .= " WHERE mid = $mid ORDER BY visible DESC, side, weight";
		$result = $xoopsDB->query( $sql );
		while( $myrow = $xoopsDB->fetchArray($result) ) {
			$block = new XoopsBlock( $myrow );
			$this->blocks[$block->getVar("bid")] = array(
				'bid' => $block->getVar("bid"), 
				'mid' => $block->getVar("mid"), 
				'title' => $block->getVar("title"), 
				'css' => '', 
				'current' => '', 
				'selected' => ''
			);
		}
	}

	/**
	 * getBlocks
	 * 
	 * @param void
	 * @return void
	 */
	function getBlocks() {
		return $this->blocks;
	}

	/**
	 * setBlockDirCss
	 * 
	 * @param $dirname
	 * @param 
	 * @param null
	 * @return void
	 */
	function setBlockDirCss( $dirname = null ) {
		$blocklist = $this->blocks;
		foreach( $blocklist as $key => $block ) {
			if ( ! empty($dirname) ) {
				$css_path = XOOPS_ROOT_PATH .'/modules/' .$dirname .'/css/';
			} else {
				$css_path = XOOPS_ROOT_PATH .'/css/';
			}
			if ( file_exists($css_path) && is_dir($css_path) ) {
				$handle = opendir( $css_path );
				while (false !== ($file = readdir($handle))) {
					if ( is_file($css_path .$file) && !preg_match("/^\..*$/",$file) ) {
						$this->blocks[$key]['css'][] = basename( $file );
						if ( !empty($this->blocks[$key]['current']) && 
							$this->blocks[$key]['current'] === basename( $file ) ) {
							$this->blocks[$key]['selected'] = basename( $file );
						}
					}
				}
				closedir($handle);
			}
		}
	}

	/**
	 * setBlockDbCss
	 * 
	 * @param $mid
	 * @return void
	 */
	function setBlockDbCss( $mid ) {
		$mid = intval( $mid );
		$xoopsDB =& Database::getInstance();
		$cssadmin_blocks = $xoopsDB->prefix( 'cssadmin_blocks' );
		$newblocks = $xoopsDB->prefix( 'newblocks' );
		$sql = "SELECT cssadmin_blocks.bid, cssadmin_blocks.css FROM $cssadmin_blocks cssadmin_blocks";
		$sql .= " LEFT JOIN $newblocks newblocks ON newblocks.bid = cssadmin_blocks.bid";
		$sql .= " WHERE cssadmin_blocks.mid = $mid";
		$result = $xoopsDB->query( $sql );
		if ( $myrow = $xoopsDB->fetchArray($result) ) {
			do {
				$bid = intval( $myrow['bid'] );
				$this->blocks[$bid]['current'] = htmlSpecialChars( $myrow['css'], ENT_QUOTES );
			} while ( $myrow = $xoopsDB->fetchArray($result) );
		}
	}

	/**
	 * setDelBlocks
	 * 
	 * @param void
	 * @return void
	 */
	function setDelBlocks() {
		// 
		$xoopsDB =& Database::getInstance();
		$cssadmin_blocks = $xoopsDB->prefix( 'cssadmin_blocks' );
		$newblocks = $xoopsDB->prefix( 'newblocks' );
		$bid_list = array();
		$bids = '';
		// ¸ߤƤ֥åID
		$sql = "SELECT bid FROM $newblocks";
		$result = $xoopsDB->query( $sql );
		if ( $myrow = $xoopsDB->fetchArray($result) ) {
			do {
				$bid_list[] = intval($myrow['bid']);
			} while ( $myrow = $xoopsDB->fetchArray($result) );
		}
		// ֥åCSSˡ¸ߤƤʤ֥åξ󤬴ޤޤƤʤǧ
		if ( ! empty($bid_list) ) {
			$bids = implode( ',', $bid_list );
			$sql = "SELECT bid FROM $cssadmin_blocks";
			$sql .= " WHERE bid NOT IN ( $bids )";
			$result = $xoopsDB->query( $sql );
			if ( $myrow = $xoopsDB->fetchArray($result) ) {
				do {
					$bid = intval($myrow['bid']);
					$this->del_blocks[$bid] = $bid;
				} while ( $myrow = $xoopsDB->fetchArray($result) );
			}
		}
	}

	/**
	 * getDelBlocks
	 * 
	 * @param void
	 * @return void
	 */
	function getDelBlocks() {
		return $this->del_blocks;
	}

	/**
	 * sanitizeArray4disp
	 * 
	 * @param $array
	 * @param $level
	 * @param 
	 * @param 1
	 * @return void
	 */
	function sanitizeArray4disp( $array ) {
		// MyTextSanitizer󥹥󥹤
		$myts =& MyTextSanitizer::getInstance();
		$array4disp = array();
		// Ϥ줿$arrayŸ
		foreach ( $array as $key => $object ) {
			// Ÿ줿$objectξ硢Ÿ
			if ( is_array($object) ) {
				foreach ( $object as $key2 => $object2 ) {
					// Ÿ줿$object2ξ硢Ÿ
					if ( is_array($object2) ) {
						foreach ( $object2 as $key3 => $object3 ) {
							// $object3ʸ
							if ( is_string($object3) ) {
								// $object3ʣ
								if ( (strstr($object3, "\n")) || (strpos($object3, "\r")) ) {
									$array4disp[$key][$key2][$key3] = $myts->displayTarea( $object3, $html = 0, $smiley = 0, $xcode = 0, $image = 0, $br = 1 );
								// $object3ñ
								} elseif ( !empty($object3) || $object3 === '0' ) {
									$array4disp[$key][$key2][$key3] = $myts->htmlSpecialChars( $object3, ENT_QUOTES );
								// $object3null,ʸ,ʸ0Τ줫
								} else {
									$array4disp[$key][$key2][$key3] = '';
								}
							// $object3int
							} elseif ( is_int($object3) ) {
								$array4disp[$key][$key2][$key3] = intval( $object3 );
							}
						}
					// $object2ʸ
					} elseif ( is_string($object2) ) {
						// $object2ʣ
						if ( (strstr($object2, "\n")) || (strpos($object2, "\r")) ) {
							$array4disp[$key][$key2] = $myts->displayTarea( $object2, $html = 0, $smiley = 0, $xcode = 0, $image = 0, $br = 1 );
						// $object2ñ
						} elseif ( !empty($object2) || $object2 === '0' ) {
							$array4disp[$key][$key2] = $myts->htmlSpecialChars( $object2, ENT_QUOTES );
						// $object2null,ʸ,ʸ0Τ줫
						} else {
							$array4disp[$key][$key2] = '';
						}
					// $object2int
					} elseif ( is_int($object2) ) {
						$array4disp[$key][$key2] = intval( $object2 );
					}
				}
			// $objectʸ
			} elseif ( is_string($object) ) {
				// $objectʣ
				if ( (strstr($object, "\n")) || (strpos($object, "\r")) ) {
					$array4disp[$key] = $myts->displayTarea( $object, $html = 0, $smiley = 0, $xcode = 0, $image = 0, $br = 1 );
				// $objectñ
				} elseif ( !empty($object) || $object === '0' ) {
					$array4disp[$key] = $myts->htmlSpecialChars( $object, ENT_QUOTES );
				// $objectnull,ʸ,ʸ0Τ줫
				} else {
					$array4disp[$key] = '';
				}
			// $objectint
			} elseif ( is_int($object) ) {
				$array4disp[$key] = intval( $object );
			}
		}
		return $array4disp;
	}

// end of class
}

$MyCssAdmin = new MyCssAdmin();

}

?>