/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class PopulateBeanUtils {
    private static Logger m_log = Logger.getLogger(PopulateBeanUtils.class);

    public static void populateBean(Object form, HttpServletRequest request) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration<String> names = (Enumeration<String>) request
                    .getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String) names.nextElement();
                if (!(name.contains("["))) {
                    map.put(name, request.getParameterValues(name));
                }
            }
            BeanUtils.populate(form, map);
        } catch (IllegalAccessException e) {
            m_log.error("populateBean: "+e.getMessage());
        } catch (InvocationTargetException e) {
            m_log.error("populateBean: "+e.getMessage());
        }
    }
}
