/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;
import com.necsoft.hinemos.webclient.repository.business.GetNodeListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for display header of node view
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeListTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -975394539239284271L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeListTableDefineServlet.class);

    @Override
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        GetNodeListTableDefineBusiness business = null;

        try {
            HttpSession session = request.getSession();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            Set<String> managerIpSet = loginManagerMap.keySet();
            //get data
            business = new GetNodeListTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = business.getNodeListTableDefine(request.getLocale(), managerIpSet.size() > 1);
            int maxRowNum = (Integer)request.getSession().getServletContext().getAttribute(Constants.REPOSITORY_NODE_MAX_ROW);

            //convert to Json
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    maxRowNum,
                    GetNodeListTableDefine.SORT_COLUMN_INDEX,
                    GetNodeListTableDefine.SORT_ORDER);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }
}