/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodeFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * ノード情報データをリフレッシュするクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeFilterPropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeFilterPropertyServlet.class);

    @Override
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            //get data
            Property propertyNode = getNodeFilterProperty(request);

            //convert to json
            result = DataProcess.doConvertFilterToJson(propertyNode);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    private Property getNodeFilterProperty(HttpServletRequest request)
            throws HinemosWebException {
        // 中間変数を宣言
        Property propertyNode = null;
        HttpSession session = request.getSession(true);
        GetNodeFilterPropertyBusiness business = null;
        String lang = (String)session
            .getAttribute(Constants.NODE_FILTER_PROPERTIES_LANG);
        String cur_lang = request.getLocale().getLanguage();
        if (session.getAttribute(Constants.NODE_FILTER_PROPERTIES) == null ||!(cur_lang.equals(lang))) {
            business = new GetNodeFilterPropertyBusiness();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            Set<String> managerIpSet = loginManagerMap.keySet();
            propertyNode = business.getNodeFilterProperty(request.getLocale(), managerIpSet);
            session.setAttribute(Constants.NODE_FILTER_PROPERTIES, propertyNode);
            session.setAttribute(Constants.NODE_FILTER_PROPERTIES_LANG,cur_lang);
        } else {
            propertyNode = (Property) session
                    .getAttribute(Constants.NODE_FILTER_PROPERTIES);
        }
        return propertyNode;
    }
}