/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.clustercontrol.repository.bean.AgentCommandConstant;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.business.AgentRestartBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for display data of agent view
 *
 */
public class AgentRestartServlet extends CommonServlet {

    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils.getLogUtils(AgentRestartServlet.class);

    @Override
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        try {
            String unavailableManagerIp = restart(request);
            if (unavailableManagerIp == null) {

            } else if (unavailableManagerIp.isEmpty()) {
                logUtils.info("exception.data.operation");
                result = ExceptionHandlerUtils.doBuildCommonJson(
                        ExceptionHandlerUtils.LEVEL_INFO, "exception.data.operation",
                        request.getLocale());
            } else {
                logUtils.info("exception.data.operation");
                result.setMessage(WebMessages.getString("exception.data.operation", request.getLocale()) + "(" + unavailableManagerIp + ")");
                result.setResult(ExceptionHandlerUtils.LEVEL_INFO);
            }
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_INFO, ex.getMessage(),
                    request.getLocale());
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    request.getLocale());
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(),
                    request.getLocale());
        }
        return result;
    }

    private String restart(HttpServletRequest request) throws HinemosWebException,Exception {
        String action = request.getParameter("action");

        int agentCommand = -1;
        if("restart".equals(action)){
        	agentCommand = AgentCommandConstant.RESTART;
        }else if ("update".equals(action)) {
        	agentCommand = AgentCommandConstant.UPDATE;
		}else{
			throw new Exception("invalid action parameter.");
		}

        String[] facilityIds = request.getParameterValues("facilityId[]");
        String[] managerIps = request.getParameterValues("managerIp[]");

        HttpSession session = request.getSession(true);
        synchronized(session) {
            AgentRestartBusiness business = new AgentRestartBusiness();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            return business.restartAgent(agentCommand, facilityIds, managerIps, loginManagerMap);
        }
    }
}
