/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.action.GetNodeScopeTableDefine;
import com.necsoft.hinemos.webclient.repository.form.NodeScopeForm;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for get data of NodeScope view
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeScopeBusiness {

    public ArrayList<ArrayList<Object>> getNodeScope(NodeScopeForm form, LinkedHashMap<String, LoginManager> loginManagerMap) throws HinemosWebException {
        String facilityId = form.getFacilityId();
        String managerIpForSearch = form.getManagerIpForSearch();
        if (facilityId == null || facilityId.trim().isEmpty()) {
            return new ArrayList<ArrayList<Object>>();
        } else {
            if (managerIpForSearch == null || managerIpForSearch.trim().isEmpty()) {
                Set<String> managerIpSet = loginManagerMap.keySet();
                Iterator<String> iterator = managerIpSet.iterator();
                while (iterator.hasNext()) {
                    String managerIp = iterator.next();
                    return getNodeScope(form, loginManagerMap.get(managerIp).endpointManager);
                }
            }
            return getNodeScope(form, loginManagerMap.get(managerIpForSearch).endpointManager);
        }
    }
    private ArrayList<ArrayList<Object>> getNodeScope(NodeScopeForm form, EndpointManager endpointManager) throws HinemosWebException {

        List<String> listInfoData = null;
        try {
            listInfoData = RepositoryEndpointWrapper.getNodeScopeList(StringEscapeUtils
                    .unescapeHtml4(form.getFacilityId()), endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil.convertNodeScopeInfoToList(listInfoData);

        // Sanitize
        ConvertListUtil.sanitizeNodeScopeInfoData(list);

        // Sort data
        DataProcess.doSortListDataInfo(form, list,
                GetNodeScopeTableDefine.SORT_COLUMN_INDEX,
                GetNodeScopeTableDefine.SORT_ORDER);

        return list;
    }
}