/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;

/**
 * This class used to display Node List Business
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeListTableDefineBusiness {

    public ArrayList<TableColumnInfoJs> getNodeListTableDefine(Locale locale, boolean isManagerIpRequired)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;
        // ...(GetNodeListTableDefine)を取得
        tblDefine = GetNodeListTableDefine.get(locale, isManagerIpRequired);
        // ...テーブルヘッダー定義データの項目数チェック
        if (isManagerIpRequired) {
            if (tblDefine.size() != RepositoryConstants.NODE_LIST_TABLE_HEADER_NUM_WITH_MANAGER) {
                throw new HinemosWebHeaderInvalidException("exception.header.number");
            }
        } else {
            if (tblDefine.size() != RepositoryConstants.NODE_LIST_TABLE_HEADER_NUM_WITHOUT_MANAGER) {
                throw new HinemosWebHeaderInvalidException("exception.header.number");
            }
        }

        return tblDefine;
    }
}