/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.repository.action.GetNodeList;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;
import com.necsoft.hinemos.webclient.repository.form.NodeListForm;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * 登録ノードのリストを取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeListBusiness {

    public List<ArrayList<Object>> getNodeList(NodeListForm form, Property condition,
            LinkedHashMap<String, LoginManager> loginManagerMap) throws HinemosWebException {

        List<ArrayList<Object>> listInfoData = new ArrayList<ArrayList<Object>>();
        Set<String> managerIpSet = loginManagerMap.keySet();
        if (condition != null) {
            Object[] listCondElement = condition.getChildren();
            for (int count = 0; count < listCondElement.length; count++) {
                Property condElement = (Property) listCondElement[count];
                if (MonitorConstants.FILTER_CONDITION_ID_MANAGER
                        .equals(condElement.getID())) {
                    String managerIp = (String) condElement.getValue();
                    if (managerIp != null && !managerIp.trim().isEmpty()) {
                        listInfoData.addAll(getNodeList(condition, loginManagerMap.get(managerIp).endpointManager, managerIp));

                        listInfoData = DataProcess.doSortListDataInfo(form, listInfoData, GetNodeListTableDefine.SORT_COLUMN_INDEX, GetNodeListTableDefine.SORT_ORDER);
                        ConvertListUtil.sanitizeNodeInfoData(listInfoData);
                        return listInfoData;
                    }
                    break;
                }
            }
        }
        Iterator<String> iterator = managerIpSet.iterator();
        while (iterator.hasNext()) {
            String managerIp = iterator.next();
            LoginManager loginManager = loginManagerMap.get(managerIp);
            // シングルログインの場合、マネージャIPが不要なので、nullに設定
            if (managerIpSet.size() <= 1) {
                managerIp = null;
            }
            if (condition == null) {
                listInfoData.addAll(getNodeList(loginManager.endpointManager,
                        managerIp));
            } else {
                listInfoData.addAll(getNodeList(condition, loginManager.endpointManager,
                        managerIp));
            }
        }

        listInfoData = DataProcess.doSortListDataInfo(form, listInfoData, GetNodeListTableDefine.SORT_COLUMN_INDEX, GetNodeListTableDefine.SORT_ORDER);
        ConvertListUtil.sanitizeNodeInfoData(listInfoData);

        return listInfoData;
    }

    private ArrayList<ArrayList<Object>> getNodeList(EndpointManager endpointManager, String managerIp)
        throws HinemosWebException {
        ArrayList<ArrayList<Object>> listNodeData;
        // ノード情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        listNodeData = nodeList.getAll(endpointManager, managerIp);
        return listNodeData;
    }

    private ArrayList<ArrayList<Object>> getNodeList(Property condition,
            EndpointManager endpointManager, String managerIp) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listNodeData;
        // ノード情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        listNodeData = nodeList.get(condition, endpointManager, managerIp);

        return listNodeData;
    }

}