/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.action.GetAgentListTableDefine;
import com.necsoft.hinemos.webclient.repository.form.AgentListForm;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for get data of Agent view
 *
 */
public class GetAgentListBusiness {

    public List<ArrayList<Object>> getAgentList(AgentListForm form,
            LinkedHashMap<String, LoginManager> loginManagerMap) throws HinemosWebException {
        List<ArrayList<Object>> listInfoData = new ArrayList<ArrayList<Object>>();
        Set<String> managerIpSet = loginManagerMap.keySet();
        Iterator<String> iterator = managerIpSet.iterator();
        while (iterator.hasNext()) {
            String managerIp = iterator.next();
            LoginManager loginManager = loginManagerMap.get(managerIp);
            // シングルログインの場合、マネージャIPが不要なので、nullに設定
            if (managerIpSet.size() <= 1) {
                managerIp = null;
            }
            listInfoData.addAll(getAgentList(form, loginManager.endpointManager,
                    managerIp));
        }

        // Sanitize
        ConvertListUtil.sanitizeNodeInfoData(listInfoData);

        // Sort data
        DataProcess.doSortListDataInfo(form, listInfoData, GetAgentListTableDefine.SORT_COLUMN_INDEX, GetAgentListTableDefine.SORT_ORDER);

        return listInfoData;
    }

    private ArrayList<ArrayList<Object>> getAgentList(AgentListForm form,
        EndpointManager endpointManager, String managerIp) throws HinemosWebException {

        // データ取得
        List<AgentStatusInfo> records = null;
        try {
            records = RepositoryEndpointWrapper.getAgentStatusList(endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
            .agentInfoListToArrayList(records, managerIp);

        return list;
    }

}