/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for get data of Agent view
 *
 */
public class AgentRestartBusiness {

    public String restartAgent(int agentCommand, String[] facilityIds, String[] managerIps,
            LinkedHashMap<String, LoginManager> loginManagerMap)
            throws HinemosWebException {
        String unavailableManagerIp = null;

        // マルチログインの場合、managerIp配列が取得できる
        if (managerIps != null && managerIps.length > 0) {
            // managerIpとfacilityIdリストの関係を保存するHashMap
            Map<String, ArrayList<String>> restartAgentMap = new HashMap<String, ArrayList<String>>();
            for (int i = 0; i < managerIps.length; i++) {
                ArrayList<String> facilityIdList = restartAgentMap.get(managerIps[i]);
                if (facilityIdList == null) {
                    facilityIdList = new ArrayList<String>();
                }
                facilityIdList.add(facilityIds[i]);
                restartAgentMap.put(managerIps[i], facilityIdList);
            }
            Set<String> managerIpSet = restartAgentMap.keySet();
            Iterator<String> iterator = managerIpSet.iterator();
            while (iterator.hasNext()) {
                String managerIp = iterator.next();
                boolean isSuccessful = restartAgent(restartAgentMap.get(managerIp), agentCommand, loginManagerMap.get(managerIp).endpointManager);
                if (!isSuccessful && unavailableManagerIp == null) {
                    unavailableManagerIp = managerIp;
                }
            }
        }
        // シングルログインの場合
        else {
            ArrayList<String> facilityIdList = new ArrayList<String>(Arrays.asList(facilityIds));
            Iterator<LoginManager> iterator = loginManagerMap.values().iterator();
            while (iterator.hasNext()) {
                LoginManager loginManager = iterator.next();
                boolean isSuccessful = restartAgent(facilityIdList, agentCommand, loginManager.endpointManager);
                if (!isSuccessful) {
                    unavailableManagerIp = "";
                }
                break;
            }
        }
        return unavailableManagerIp;
    }

    private boolean restartAgent(ArrayList<String> facilityIdList,
        	 int agentCommand, EndpointManager endpointManager) throws HinemosWebAccessException, HinemosWebException {
            try {
                RepositoryEndpointWrapper.restartAgent(facilityIdList, agentCommand,endpointManager);
            } catch (InvalidRole_Exception e) {
                // 操作権なしの場合
                return false;
            } catch (HinemosUnknown_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (InvalidUserPass_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebException("exception.data.access");
            } catch (WebServiceException e) {
                // Hinemosマネージャより応答がありませんでした。ログアウトします。
                throw new HinemosWebException("message.force.disconnect");
            }
            return true;
        }

}