/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.util.RepositoryMappingUtil;

/**
 * 登録ノード一覧テーブルの定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeListTableDefine {

    /** ファシリティID */
    public static final int FACILITY_ID = 0;

    /** ファシリティ名 */
    public static final int FACILITY_NAME = 1;

    /** プラットフォーム */
    public static final int PLATFORM = 2;

    /** IPアドレス */
    public static final int IP_ADDRESS = 3;

    /** 説明 */
    public static final int DESCRIPTION = 4;

    /** マネージャ */
    public static final int MANAGER = 5;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = FACILITY_ID;

    /** 初期表示時ソートオーダー */
    public static final int SORT_ORDER = 1;

    /**
     * 全てのノード一覧を取得します。
     *
     * @return ノード一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale, boolean isManagerIpRequired) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.FACILITY_ID, 100, SWT.LEFT,
                RepositoryMappingUtil.getNodeName(FACILITY_ID)));
        tableDefine.add(FACILITY_NAME, new TableColumnInfoJs(
                WebMessages.getString("facility.name", locale),
                TableColumnInfoJs.FACILITY_NAME, 150, SWT.LEFT,
                RepositoryMappingUtil.getNodeName(FACILITY_NAME)));
        tableDefine.add(PLATFORM, new TableColumnInfoJs(
                WebMessages.getString("platform.family.name",locale),
                TableColumnInfoJs.NONE, 120, SWT.LEFT,
                RepositoryMappingUtil.getNodeName(PLATFORM)));
        tableDefine.add(IP_ADDRESS, new TableColumnInfoJs(
                WebMessages.getString("ip.address", locale),
                TableColumnInfoJs.NONE, 120, SWT.LEFT,
                RepositoryMappingUtil.getNodeName(IP_ADDRESS)));
        tableDefine.add(DESCRIPTION, new TableColumnInfoJs(
                WebMessages.getString("description",locale),
                TableColumnInfoJs.NONE, 200, SWT.LEFT,
                RepositoryMappingUtil.getNodeName(DESCRIPTION)));
        if (isManagerIpRequired) {
            tableDefine.add(
                    MANAGER,
                    new TableColumnInfoJs(WebMessages.getString("manager",
                            locale), TableColumnInfoJs.NONE, 150, SWT.LEFT,
                            RepositoryMappingUtil.getNodeName(MANAGER)));
        }
        return tableDefine;
    }
}