/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.util.NodePropertyUtil;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

public class GetNodeList {
    /**
     * 全てのノード一覧を取得します。
     *
     * @return ノード一覧
     */
    public ArrayList<ArrayList<Object>> getAll(EndpointManager endpointManager, String managerIp)
            throws HinemosWebException {

        List<NodeInfo> records = null;
        try {
            records = RepositoryEndpointWrapper.getNodeListAll(endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil.nodeInfoListToArrayList(records, managerIp);
        return list;
    }

    /**
     * propertyの条件にヒットするノードの一覧を返します。
     *
     * @param property
     * @return ノード一覧
     */
    public ArrayList<ArrayList<Object>> get(Property property,
            EndpointManager endpointManager, String managerIp) throws HinemosWebException {

        PropertyUtil.deletePropertyDefine(property);

        List<NodeInfo> records = null;
        try {
            NodeInfo nodeInfo = null;
            nodeInfo = NodePropertyUtil.property2node(property);
            records = RepositoryEndpointWrapper.getFilterNodeList(nodeInfo, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil.nodeInfoListToArrayList(records, managerIp);
        return list;
    }
}