/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.monitor.bean.EventFilterConstant;
import com.clustercontrol.monitor.bean.StatusFilterConstant;
import com.clustercontrol.ws.monitor.EventBatchConfirmInfo;
import com.necsoft.hinemos.webclient.bean.PriorityConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

public class EventBatchConfirmPropertyUtil {
	/**
	* プロパティをイベント一括確認情報DTOに変換するメソッドです。
	*
	* @param property
	* @return イベント一括確認情報
	*/
	public static EventBatchConfirmInfo property2dto(Property property, Locale locale){
		EventBatchConfirmInfo info = new EventBatchConfirmInfo();

		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;
		String comment = null;
		String commentUser = null;

		ArrayList values = null;

		//重要度取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + StatusFilterConstant.PRIORITY);
		if (!"".equals(values.get(0))) {
			int priorityType = PriorityConstant.stringToType((String) values.get(0), locale);
			if (priorityType != -1) {
				priority = new Integer(priorityType);
				info.setPriority(priority);
			}
		}

		//更新日時（自）取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.OUTPUT_FROM_DATE);
		if (values.get(0) instanceof Date) {
			outputFromDate = new Timestamp(((Date) values.get(0)).getTime());
			outputFromDate.setNanos(0);
			info.setOutputFromDate(outputFromDate.getTime());
		}

		//更新日時（至）取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.OUTPUT_TO_DATE);
		if (values.get(0) instanceof Date) {
			outputToDate = new Timestamp(((Date) values.get(0)).getTime());
			outputToDate.setNanos(999999999);
			info.setOutputToDate(outputToDate.getTime());
		}

		//出力日時（自）取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.GENERATION_FROM_DATE);
		if (values.get(0) instanceof Date) {
			generationFromDate = new Timestamp(((Date) values.get(0))
					.getTime());
			generationFromDate.setNanos(0);
			info.setGenerationFromDate(generationFromDate.getTime());
		}

		//出力日時（至）取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.GENERATION_TO_DATE);
		if (values.get(0) instanceof Date) {
			generationToDate = new Timestamp(((Date) values.get(0))
					.getTime());
			generationToDate.setNanos(999999999);
			info.setGenerationToDate(generationToDate.getTime());
		}

		//対象ファシリティ種別取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + StatusFilterConstant.FACILITY_TYPE);
		if (!"".equals(values.get(0))) {
			facilityType = (String) values.get(0);
			info.setFacilityType(facilityType);
		}

		//アプリケーション取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + StatusFilterConstant.APPLICATION);
		if (!"".equals(values.get(0))) {
			application = (String) values.get(0);
			info.setApplication(application);
		}

		//メッセージ取得
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + StatusFilterConstant.MESSAGE);
		if (!"".equals(values.get(0))) {
			message = (String) values.get(0);
			info.setMessage(message);
		}

		// コメント
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.COMMENT);
		if (!"".equals(values.get(0))) {
			comment = (String) values.get(0);
		}
		info.setComment(comment);

		// コメントユーザ
		values = PropertyUtil.getPropertyValue(property,
				"batchData" + EventFilterConstant.COMMENT_USER);
		if (!"".equals(values.get(0))) {
			commentUser = (String) values.get(0);
		}
		info.setCommentUser(commentUser);

		return info;
	}


	/**
	* イベント情報一括確認用プロパティを取得します。<BR>
	* <p>
	* <ol>
	*  <li>一括確認項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	*      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	*  <li>各一括確認項目のプロパティをツリー状に定義します。</li>
	* </ol>
	*
	* <p>プロパティに定義するフィルタ条件は、下記の通りです。
	* <p>
	* <ul>
	*  <li>プロパティ（親。ダミー）</li>
	*  <ul>
	*   <li>重要度（子。コンボボックス）</li>
	*   <li>受信日時（子。テキスト）</li>
	*   <ul>
	*    <li>開始（孫。日時ダイアログ）</li>
	*    <li>終了（孫。日時ダイアログ）</li>
	*   </ul>
	*   <li>出力日時（子。テキスト）</li>
	*   <ul>
	*    <li>開始（孫。日時ダイアログ）</li>
	*    <li>終了（孫。日時ダイアログ）</li>
	*   </ul>
	*   <li>ファシリティのターゲット（子。コンボボックス）</li>
	*   <li>アプリケーション（子。テキスト）</li>
	*   <li>メッセージ（子。テキスト）</li>
	*   <li>コメント</li>
	*   <li>コメントユーザ</li>
	*  </ul>
	* </ul>
	*
	* @param locale ロケール情報
	* @return イベント情報一括確認用プロパティ
	*/
	public static Property getProperty(Locale locale, Set<String> managerIpSet) {

		//重要度
		Property m_priority = new Property(
			"batchData" + EventFilterConstant.PRIORITY,
			WebMessages.getString("priority", locale),
			PropertyConstant.EDITOR_SELECT);

		//受信日時（自）
		Property m_outputFromDate =	new Property(
			"batchData" + EventFilterConstant.OUTPUT_FROM_DATE,
			WebMessages.getString("start", locale),
			PropertyConstant.EDITOR_DATETIME);

		//受信日時（至）
		Property m_outputToDate = new Property(
			"batchData" + EventFilterConstant.OUTPUT_TO_DATE,
			WebMessages.getString("end", locale),
			PropertyConstant.EDITOR_DATETIME);

		//出力日時（自）
		Property m_generationFromDate = new Property(
			"batchData" + EventFilterConstant.GENERATION_FROM_DATE,
			WebMessages.getString("start", locale),
			PropertyConstant.EDITOR_DATETIME);

		//出力日時（至）
		Property m_generationToDate = new Property(
			"batchData" + EventFilterConstant.GENERATION_TO_DATE,
			WebMessages.getString("end", locale),
			PropertyConstant.EDITOR_DATETIME);

		//対象ファシリティ種別
		Property m_facilityType = new Property(
			"batchData" + EventFilterConstant.FACILITY_TYPE,
			WebMessages.getString("facility.target", locale),
			PropertyConstant.EDITOR_SELECT);

		//アプリケーション
		Property m_application = new Property(
			"batchData" + EventFilterConstant.APPLICATION,
			WebMessages.getString("application", locale),
			PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);

		//メッセージ
		Property m_message = new Property(
			"batchData" + EventFilterConstant.MESSAGE,
			WebMessages.getString("message", locale),
			PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);

		//受信日時
		Property m_outputDate = new Property(
			"batchData" + EventFilterConstant.OUTPUT_DATE,
			WebMessages.getString("receive.time", locale),
			PropertyConstant.EDITOR_TEXT);

		//出力日時
		Property m_generationDate = new Property(
			"batchData" + EventFilterConstant.GENERATION_DATE,
			WebMessages.getString("output.time", locale),
			PropertyConstant.EDITOR_TEXT);

		// コメント
		Property m_comment = new Property(
			"batchData" + EventFilterConstant.COMMENT,
			WebMessages.getString("comment", locale),
			PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);

		// コメントユーザ
		Property m_commentUser = new Property(
			"batchData" + EventFilterConstant.COMMENT_USER,
			WebMessages.getString("comment.user", locale),
			PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);

		// マネージャ列でフィルタ
        Property m_manager = null;
        if (managerIpSet.size() > 1) {
            m_manager = new Property(
                    MonitorConstants.FILTER_CONDITION_ID_MANAGER,
                    WebMessages.getString("manager", locale),
                    PropertyConstant.EDITOR_SELECT);

            Object[][] managerIpValues = new Object[2][];
            String[] managerIps = new String[managerIpSet.size() + 1];
            managerIps[0] = "";
            Iterator<String> iterator = managerIpSet.iterator();
            for (int i = 1; iterator.hasNext(); i++) {
                managerIps[i] = iterator.next();
            }
            managerIpValues[0] = managerIps;
            managerIpValues[1] = managerIps;
            m_manager.setSelectValues(managerIpValues);
            m_manager.setValue("");
            m_manager.setModify(PropertyConstant.MODIFY_OK);
        }

		//値を初期化
		Object priorityValues[][] = {
				{ "", WebMessages.getString("critical", locale),
					WebMessages.getString("warning", locale),
					WebMessages.getString("info", locale),
					WebMessages.getString("unknown", locale)},
				{ "", WebMessages.getString("critical", locale),
					WebMessages.getString("warning", locale),
					WebMessages.getString("info", locale),
					WebMessages.getString("unknown", locale)}
		};

		m_priority.setSelectValues(priorityValues);
		m_priority.setValue(WebMessages.getString("critical", locale));

		m_outputFromDate.setValue("");
		m_outputToDate.setValue("");
		m_generationFromDate.setValue("");
		m_generationToDate.setValue("");

		Object facilityTypeValues[][] = {
				{ WebMessages.getString("facility.target.all", locale),
					WebMessages.getString("facility.target.beneath", locale)},
				{ WebMessages.getString("facility.target.all", locale),
					WebMessages.getString("facility.target.beneath", locale)}
		};

		m_facilityType.setSelectValues(facilityTypeValues);
		m_facilityType.setValue(WebMessages.getString("facility.target.all", locale));

		m_application.setValue("");
		m_message.setValue("");

		m_outputDate.setValue("");
		m_generationDate.setValue("");

		m_comment.setValue("");
		m_commentUser.setValue("");

		//変更の可/不可を設定
		m_priority.setModify(PropertyConstant.MODIFY_OK);
		m_outputFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_outputToDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationToDate.setModify(PropertyConstant.MODIFY_OK);
		m_facilityType.setModify(PropertyConstant.MODIFY_OK);
		m_application.setModify(PropertyConstant.MODIFY_OK);
		m_message.setModify(PropertyConstant.MODIFY_OK);

		m_outputDate.setModify(PropertyConstant.MODIFY_NG);
		m_generationDate.setModify(PropertyConstant.MODIFY_NG);

		m_comment.setModify(PropertyConstant.MODIFY_OK);
		m_commentUser.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_priority);
		property.addChildren(m_outputDate);
		property.addChildren(m_generationDate);
		property.addChildren(m_facilityType);
		property.addChildren(m_application);
		property.addChildren(m_message);

		// 受信日時
		m_outputDate.removeChildren();
		m_outputDate.addChildren(m_outputFromDate);
		m_outputDate.addChildren(m_outputToDate);

		// 出力日時
		m_generationDate.removeChildren();
		m_generationDate.addChildren(m_generationFromDate);
		m_generationDate.addChildren(m_generationToDate);

		property.addChildren(m_comment);
		property.addChildren(m_commentUser);
        if (m_manager != null) {
            property.addChildren(m_manager);
        }

		return property;
	}
}
