/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;

import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.necsoft.hinemos.webclient.monitor.action.GetEventListTableDefine;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusListTableDefine;

/**
 * 表示用のリストに変換するクラス
 **/
public class ConvertListUtil {

    /********************************************************************
     * Scope
     */
    /**
     * @param list
     * @return
     */
    public static ArrayList<ArrayList<Object>> scopeInfoDataListToArrayList(
            List<ScopeDataInfo> list, String managerIp) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<ScopeDataInfo> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> status = new ArrayList<Object>();
            ScopeDataInfo scopeInfoData = itr.next();

            status.add(GetScopeListTableDefine.PRIORITY,
                    scopeInfoData.getPriority());

            status.add(GetScopeListTableDefine.FACILITY_ID,
                    scopeInfoData.getFacilityId());

            status.add(GetScopeListTableDefine.SCOPE,
                    scopeInfoData.getFacilityPath());

            if (managerIp != null) {
                status.add(GetScopeListTableDefine.MANAGER, managerIp);
            }
            ret.add(status);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeScopeInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(GetScopeListTableDefine.FACILITY_ID) != null) {
                row.set(GetScopeListTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScopeListTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(GetScopeListTableDefine.SCOPE) != null) {
                row.set(GetScopeListTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScopeListTableDefine.SCOPE).toString()));
            }
        }
    }

    /********************************************************************
     * Status
     */
    public static ArrayList<ArrayList<Object>> statusInfoDataListToArrayList(
            List<StatusDataInfo> list, String managerIp) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<StatusDataInfo> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> status = new ArrayList<Object>();
            StatusDataInfo statusInfoData = itr.next();

            status.add(GetStatusListTableDefine.PRIORITY,
                    statusInfoData.getPriority());

            status.add(GetStatusListTableDefine.PLUGIN_ID,
                    statusInfoData.getPluginId());

            status.add(GetStatusListTableDefine.MONITOR_ID,
                    statusInfoData.getMonitorId());

            status.add(GetStatusListTableDefine.MONITOR_DETAIL_ID,
                    statusInfoData.getMonitorDetailId());

            status.add(GetStatusListTableDefine.FACILITY_ID,
                    statusInfoData.getFacilityId());

            status.add(GetStatusListTableDefine.SCOPE,
                    statusInfoData.getFacilityPath());

            status.add(GetStatusListTableDefine.APPLICATION,
                    statusInfoData.getApplication());

            status.add(GetStatusListTableDefine.UPDATE_TIME,
                    statusInfoData.getOutputDate());

            status.add(GetStatusListTableDefine.OUTPUT_TIME,
                    statusInfoData.getGenerationDate());

            status.add(GetStatusListTableDefine.MESSAGE_ID,
                    statusInfoData.getMessageId());

            status.add(GetStatusListTableDefine.MESSAGE,
                    statusInfoData.getMessage());

            if (managerIp != null) {
                status.add(GetStatusListTableDefine.MANAGER, managerIp);
            }
            ret.add(status);
        }

        return ret;

    }

    /**
     * @param list
     */
    public static void sanitizeStatusInfoData(List<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);
            if (row.get(GetStatusListTableDefine.PLUGIN_ID) != null) {
                row.set(GetStatusListTableDefine.PLUGIN_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.PLUGIN_ID).toString()));
            }

            if (row.get(GetStatusListTableDefine.MONITOR_ID) != null) {
                row.set(GetStatusListTableDefine.MONITOR_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.MONITOR_ID).toString()));
            }

            if (row.get(GetStatusListTableDefine.MONITOR_DETAIL_ID) != null) {
                row.set(GetStatusListTableDefine.MONITOR_DETAIL_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.MONITOR_DETAIL_ID).toString()));
            }

            if (row.get(GetStatusListTableDefine.FACILITY_ID) != null) {
                row.set(GetStatusListTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(GetStatusListTableDefine.SCOPE) != null) {
                row.set(GetStatusListTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.SCOPE).toString()));
            }

            if (row.get(GetStatusListTableDefine.APPLICATION) != null) {
                row.set(GetStatusListTableDefine.APPLICATION,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.APPLICATION).toString()));
            }

            if (row.get(GetStatusListTableDefine.MESSAGE_ID) != null) {
                row.set(GetStatusListTableDefine.MESSAGE_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.MESSAGE_ID).toString()));
            }

            if (row.get(GetStatusListTableDefine.MESSAGE) != null) {
                row.set(GetStatusListTableDefine.MESSAGE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetStatusListTableDefine.MESSAGE).toString()));
            }
        }
    }

    /********************************************************************
     * Event
     */
    /**
     *
     * SessionBean経由で取得されたEventDataInfoのリストを、
     * 表示用のリスト（ArrayListの二次元配列）に変換するためのメソッドです。
     *
     * @param list
     * @return
     */
    public static ArrayList<ArrayList<Object>> eventLogDataListToArrayList(
            List<EventDataInfo> list, String managerIp) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<EventDataInfo> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> event = new ArrayList<Object>();
            EventDataInfo eventLogData = itr.next();

            event.add(GetEventListTableDefine.PRIORITY,
                    eventLogData.getPriority());

            event.add(GetEventListTableDefine.RECEIVE_TIME,
                    eventLogData.getOutputDate());

            event.add(GetEventListTableDefine.OUTPUT_DATE,
                    eventLogData.getGenerationDate());

            event.add(GetEventListTableDefine.PLUGIN_ID,
                    eventLogData.getPluginId());

            event.add(GetEventListTableDefine.MONITOR_ID,
                    eventLogData.getMonitorId());

            event.add(GetEventListTableDefine.MONITOR_DETAIL_ID,
                    eventLogData.getMonitorDetailId());

            event.add(GetEventListTableDefine.FACILITY_ID,
                    eventLogData.getFacilityId());

            event.add(GetEventListTableDefine.SCOPE,
                    eventLogData.getScopeText());

            event.add(GetEventListTableDefine.APPLICATION,
                    eventLogData.getApplication());

            event.add(GetEventListTableDefine.MESSAGE_ID,
                    eventLogData.getMessageId());

            event.add(GetEventListTableDefine.MESSAGE,
                    eventLogData.getMessage());

            event.add(GetEventListTableDefine.CONFIRMED,
                    eventLogData.getConfirmed());

            event.add(GetEventListTableDefine.CONFIRM_USER,
                    eventLogData.getConfirmUser());

            event.add(GetEventListTableDefine.COMMENT,
                    eventLogData.getComment());

            if (managerIp != null) {
                event.add(GetEventListTableDefine.MANAGER, managerIp);
            }

            ret.add(event);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeEventDataInfo(List<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(GetEventListTableDefine.PLUGIN_ID) != null) {
                row.set(GetEventListTableDefine.PLUGIN_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.PLUGIN_ID).toString()));
            }

            if (row.get(GetEventListTableDefine.MONITOR_ID) != null) {
                row.set(GetEventListTableDefine.MONITOR_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.MONITOR_ID).toString()));
            }

            if (row.get(GetEventListTableDefine.MONITOR_DETAIL_ID) != null) {
                row.set(GetEventListTableDefine.MONITOR_DETAIL_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.MONITOR_DETAIL_ID).toString()));
            }

            if (row.get(GetEventListTableDefine.FACILITY_ID) != null) {
                row.set(GetEventListTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(GetEventListTableDefine.SCOPE) != null) {
                row.set(GetEventListTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.SCOPE).toString()));
            }

            if (row.get(GetEventListTableDefine.APPLICATION) != null) {
                row.set(GetEventListTableDefine.APPLICATION,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.APPLICATION).toString()));
            }

            if (row.get(GetEventListTableDefine.MESSAGE_ID) != null) {
                row.set(GetEventListTableDefine.MESSAGE_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.MESSAGE_ID).toString()));
            }

            if (row.get(GetEventListTableDefine.MESSAGE) != null) {
                row.set(GetEventListTableDefine.MESSAGE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.MESSAGE).toString()));
            }

            if (row.get(GetEventListTableDefine.CONFIRM_USER) != null) {
                row.set(GetEventListTableDefine.CONFIRM_USER,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.CONFIRM_USER).toString()));
            }

            if (row.get(GetEventListTableDefine.COMMENT) != null) {
                row.set(GetEventListTableDefine.COMMENT,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetEventListTableDefine.COMMENT).toString()));
            }
        }
    }

    /**
     *
     * 監視[イベント]ビューに表示される内容を基にして、 EventDataInfoのリストに変換するためのメソッドです。
     *
     * オリジナルメッセージのように、表示されていない項目については、 セットされないので注意してください。
     *
     * @param list
     * @return
     */
    public static ArrayList<EventDataInfo> listToEventDataInfoList(List<?> list) {

        ArrayList<EventDataInfo> eventLogDataList = new ArrayList<EventDataInfo>();
        Iterator<?> itr = list.iterator();
        while (itr.hasNext()) {

            ArrayList<?> event = (ArrayList<?>) itr.next();

            Integer priority = Integer.valueOf((String) event
                .get(GetEventListTableDefine.PRIORITY));
            Timestamp outputDate = new Timestamp(
                ((Date) event.get(GetEventListTableDefine.RECEIVE_TIME)).getTime());
            Timestamp generationDate = new Timestamp(
                ((Date) event.get(GetEventListTableDefine.OUTPUT_DATE)).getTime());
            String pluginId = (String) event
                .get(GetEventListTableDefine.PLUGIN_ID);
            String monitorId = (String) event
                .get(GetEventListTableDefine.MONITOR_ID);
            String monitorDetailId = (String) event
                .get(GetEventListTableDefine.MONITOR_DETAIL_ID);
            String facilityId = (String) event
                .get(GetEventListTableDefine.FACILITY_ID);
            String scopeText = (String) event
                .get(GetEventListTableDefine.SCOPE);
            String application = (String) event
                .get(GetEventListTableDefine.APPLICATION);
            String messageId = (String) event
                .get(GetEventListTableDefine.MESSAGE_ID);
            String message = (String) event
                .get(GetEventListTableDefine.MESSAGE);
            Integer confirmFlg = Integer.valueOf((String) event
                .get(GetEventListTableDefine.CONFIRMED));
            String confirmUser = (String) event
                .get(GetEventListTableDefine.CONFIRM_USER);
            String comment = (String) event
                .get(GetEventListTableDefine.COMMENT);

            EventDataInfo eventLogData = new EventDataInfo();
            eventLogData.setPriority(priority);
            eventLogData.setOutputDate(outputDate.getTime());
            eventLogData.setGenerationDate(generationDate.getTime());
            eventLogData.setPluginId(pluginId);
            eventLogData.setMonitorId(monitorId);
            eventLogData.setMonitorDetailId(monitorDetailId);
            eventLogData.setFacilityId(facilityId);
            eventLogData.setScopeText(scopeText);
            eventLogData.setApplication(application);
            eventLogData.setMessageId(messageId);
            eventLogData.setMessage(message);
            eventLogData.setConfirmed(confirmFlg);
            eventLogData.setConfirmUser(confirmUser);
            eventLogData.setComment(comment);

            eventLogDataList.add(eventLogData);
        }

        return eventLogDataList;
    }
}
