/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.necsoft.hinemos.webclient.monitor.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.business.GetStatusListBusiness;
import com.necsoft.hinemos.webclient.monitor.form.MonitorStatusForm;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * ステータス情報データをリフレッシュするクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetStatusListServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetStatusListServlet.class);

    @Override
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // Get data
            List<ArrayList<Object>> listInfoData = doLoadListInfoData(request);

            // Create JSON
            result = doConvertToJson(listInfoData);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    request.getLocale());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(),
                    request.getLocale());
        }
        return result;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private List<ArrayList<Object>> doLoadListInfoData(
            HttpServletRequest request) throws HinemosWebException {
        // 中間変数を宣言
        List<ArrayList<Object>> listInfoData = null;
        MonitorStatusForm form = new MonitorStatusForm();
        PopulateBeanUtils.populateBean(form, request);

        // get loginManager session
        HttpSession session = request.getSession(true);
        ServletContext application = request.getSession().getServletContext();
        int maxNum = (Integer)application.getAttribute(Constants.MONITOR_STATUS_MAX_ROW);
        synchronized (session) {
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session
                    .getAttribute(AccessControlConstants.LOGIN_MANAGER);
            form.setMaxRowNum(maxNum);

            // Check filter
            if (form.isFilter()) {
                Property condition = doLoadCondition(request);
                GetStatusListBusiness business = new GetStatusListBusiness();
                listInfoData = business.getStatusList(form, condition,
                        loginManagerMap, request.getLocale());
            } else {
                GetStatusListBusiness business = new GetStatusListBusiness();
                listInfoData = business.getStatusList(form, null,
                        loginManagerMap, request.getLocale());
            }
        }

        return listInfoData;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private Property doLoadCondition(HttpServletRequest request)
            throws HinemosWebException {
        HttpSession session = request.getSession(true);

        if (session.getAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES) == null) {
            // HTTPセッションのタイムアウトが発生しました。ログアウトします。
            throw new HinemosWebException("message.sessiontimeout");
        }

        Property condition = (Property) session
                .getAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES);

        convertCondition(request, condition);
        return condition;
    }

    /**
     * @param listInfoData
     * @param locale
     * @return
     */
    private GridDataJson doConvertToJson(
            List<ArrayList<Object>> listInfoData) {
        return DataProcess.doConvertTableContentToJson(listInfoData);
    }
}