/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.servlet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TreeGridJson;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.business.GetStatusFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * ステータス情報データをリフレッシュするクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetStatusFilterPropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetStatusFilterPropertyServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // Load data property
            Property propertyStatus = doLoadProperty(request);

            // Create JSON
            result = doConvertToJson(propertyStatus);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(), request.getLocale());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    private Property doLoadProperty(HttpServletRequest request) throws HinemosWebException {
        // ステータス情報一覧を取得
        HttpSession session = request.getSession(true);
        Property propertyStatus = (Property) session
                .getAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES);
        String lang = (String)session
                .getAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES_LANG);
        String cur_lang = request.getLocale().getLanguage();
        if ((propertyStatus == null) || !(cur_lang.equals(lang))) {
            GetStatusFilterPropertyBusiness business = new GetStatusFilterPropertyBusiness();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            Set<String> managerIpSet = loginManagerMap.keySet();
            propertyStatus = business.getStatusFilterProperty(request.getLocale(), managerIpSet);
            session.setAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES,
                    propertyStatus);
            session.setAttribute(MonitorConstants.STATUS_FILTER_PROPERTIES_LANG,cur_lang);
        }

        return propertyStatus;
    }

    private TreeGridJson doConvertToJson(Property propertyStatus) {
        return DataProcess.doConvertFilterToJson(propertyStatus);
    }
}