/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.servlet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TreeGridJson;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.business.GetEventBatchConfirmPropertyBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * 一括確認プロパティ情報一覧を取得するサーブレットクラス
 **/
public class GetEventBatchConfirmPropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetEventBatchConfirmPropertyServlet.class);

    @Override
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException, HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // 一括確認一覧を取得
            Property propertyEvent = doLoadProperty(request);

            // Create JSON
            result = doConvertToJson(propertyEvent);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * イベント一括確認一覧を取得する
     * @param request
     * @return イベント一括確認一覧
     * @throws HinemosWebException
     */
    private Property doLoadProperty(HttpServletRequest request) throws HinemosWebException {
        // 中間変数を宣言
        HttpSession session = request.getSession(true);
        Property propertyEvent = (Property) session.
                getAttribute(MonitorConstants.EVENT_BATCH_CONFIRM_PROPERTIES);
        String lang = (String)session.
        getAttribute(MonitorConstants.EVENT_BATCH_CONFIRM_PROPERTIES_LANG);
        String cur_lang = request.getLocale().getLanguage();
        // イベント一括確認一覧を取得
        if ((propertyEvent == null) || !(cur_lang.equals(lang))) {
            GetEventBatchConfirmPropertyBusiness business = new GetEventBatchConfirmPropertyBusiness();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            Set<String> managerIpSet = loginManagerMap.keySet();
            propertyEvent = business.getEventBatchConfirmProperty(request.getLocale(), managerIpSet);
            session.setAttribute(MonitorConstants.EVENT_BATCH_CONFIRM_PROPERTIES,
                    propertyEvent);
            session.setAttribute(MonitorConstants.EVENT_BATCH_CONFIRM_PROPERTIES_LANG,cur_lang);
        }

        return propertyEvent;
    }

    private TreeGridJson doConvertToJson(Property propertyEvent) {
        return DataProcess.doConvertFilterToJson(propertyEvent);
    }
}