/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.clustercontrol.ws.monitor.StatusFilterInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorStatusForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.monitor.util.StatusFilterPropertyUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

public class GetStatusListBusiness {

    public List<ArrayList<Object>> getStatusList(MonitorStatusForm form,
            Property condition,
            LinkedHashMap<String, LoginManager> loginManagerMap, Locale locale)
            throws HinemosWebException {
        List<ArrayList<Object>> listStatusData = new ArrayList<ArrayList<Object>>();
        String managerIpForSearch = form.getManagerIpForSearch();
        if (condition != null) {
            Object[] listCondElement = condition.getChildren();
            for (int count = 0; count < listCondElement.length; count++) {
                Property condElement = (Property) listCondElement[count];
                if (MonitorConstants.FILTER_CONDITION_ID_MANAGER
                        .equals(condElement.getID())) {
                    String managerIp = (String) condElement.getValue();
                    if (managerIp != null && !managerIp.trim().isEmpty()) {
                        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty() && !managerIp.equals(managerIpForSearch)) {
                            return listStatusData;
                        }
                        listStatusData.addAll(getStatusList(form, condition,
                                loginManagerMap.get(managerIp).endpointManager,
                                locale, managerIp));
                        listStatusData = DataProcess.doSortListDataInfo(form, listStatusData, GetStatusListTableDefine.SORT_COLUMN_INDEX, GetStatusListTableDefine.SORT_ORDER);
                        ConvertListUtil.sanitizeStatusInfoData(listStatusData);

                        return listStatusData;
                    }
                    break;
                }
            }
        }
        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty()) {
            listStatusData.addAll(getStatusList(form, condition, loginManagerMap.get(managerIpForSearch).endpointManager, locale, managerIpForSearch));
            listStatusData = DataProcess.doSortListDataInfo(form, listStatusData, GetStatusListTableDefine.SORT_COLUMN_INDEX, GetStatusListTableDefine.SORT_ORDER);
            ConvertListUtil.sanitizeStatusInfoData(listStatusData);

            return listStatusData;
        }
        Set<String> managerIpSet = loginManagerMap.keySet();
        Iterator<String> iterator = managerIpSet.iterator();
        while (iterator.hasNext()) {
            String managerIp = iterator.next();
            LoginManager loginManager = loginManagerMap.get(managerIp);
            // シングルログインの場合、マネージャIPが不要なので、nullに設定
            if (managerIpSet.size() <= 1) {
                managerIp = null;
            }
            listStatusData.addAll(getStatusList(form, condition,
                    loginManager.endpointManager, locale, managerIp));
        }

        listStatusData = DataProcess.doSortListDataInfo(form, listStatusData, GetStatusListTableDefine.SORT_COLUMN_INDEX, GetStatusListTableDefine.SORT_ORDER);

        ConvertListUtil.sanitizeStatusInfoData(listStatusData);

        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getStatusList(MonitorStatusForm form,
            Property condition, EndpointManager endpointManager, Locale locale,
            String managerIp) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listStatusData = null;
        if (condition == null) {
            listStatusData = getListStatusData(form, endpointManager, managerIp);
        } else {
            listStatusData = getListStatusData(form, condition,
                    endpointManager, locale, managerIp);
        }

        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
            MonitorStatusForm form, EndpointManager endpointManager,
            String managerIp) throws HinemosWebException {

        ArrayList<ArrayList<Object>> listStatusData = null;

        // ステータス情報一覧データ(StatusInfoData)を取得
        List<StatusDataInfo> records = null;
        try {
            records = MonitorEndpointWrapper.getStatusList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    null, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        listStatusData = ConvertListUtil.statusInfoDataListToArrayList(records,
                managerIp);

        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
            MonitorStatusForm form, Property condition,
            EndpointManager endpointManager, Locale locale, String managerIp)
            throws HinemosWebException {

        ArrayList<ArrayList<Object>> listStatusData = null;
        // ステータス情報一覧データ(StatusInfoData)を取得

        try {
            List<StatusDataInfo> records = null;
            PropertyUtil.deletePropertyDefine(condition);
            StatusFilterInfo filter = StatusFilterPropertyUtil.property2dto(
                    condition, locale);
            records = MonitorEndpointWrapper.getStatusList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    filter, endpointManager);
            listStatusData = ConvertListUtil.statusInfoDataListToArrayList(
                    records, managerIp);

        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        return listStatusData;
    }

}
