/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;

import com.clustercontrol.ws.monitor.FacilityNotFound_Exception;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorScopeForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;

public class GetScopeListBusiness {

    /**
     * ソートされたスコープリストを取得する
     * @param form
     * @param loginManagerMap
     * @param managerIp
     * @return ソートされたスコープリスト
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList<Object>> getScopeList(MonitorScopeForm form, LinkedHashMap<String, LoginManager> loginManagerMap)
            throws HinemosWebException {
        String managerIpForSearch = form.getManagerIpForSearch();
        ArrayList<ArrayList<Object>> scopeList = new ArrayList<ArrayList<Object>>();
        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty()) {
            scopeList.addAll(getScopeList(form, loginManagerMap.get(managerIpForSearch).endpointManager, managerIpForSearch));
        } else {
            Set<String> managerIpSet = loginManagerMap.keySet();
            Iterator<String> iterator = managerIpSet.iterator();
            while (iterator.hasNext()) {
                String managerIp = iterator.next();
                LoginManager loginManager = loginManagerMap.get(managerIp);
                // シングルログインの場合、マネージャIPが不要なので、nullに設定
                if (managerIpSet.size() <= 1) {
                    managerIp = null;
                }
                scopeList.addAll(getScopeList(form, loginManager.endpointManager, managerIp));
            }
        }
        DataProcess.doSortListDataInfo(form, scopeList, GetScopeListTableDefine.SORT_COLUMN_INDEX, GetScopeListTableDefine.SORT_ORDER);

        ConvertListUtil.sanitizeScopeInfoData(scopeList);
        return scopeList;
    }

    private ArrayList<ArrayList<Object>> getScopeList(MonitorScopeForm form, EndpointManager endpointManager, String managerIp)
            throws HinemosWebAccessException, HinemosWebException {
        // スコープ情報一覧データ(ScopeInfoData)を取得
        ArrayList<ArrayList<Object>> listInfoData = null;
        List<ScopeDataInfo> records = null;
        try {
            records =  MonitorEndpointWrapper.getScopeList(StringEscapeUtils
                    .unescapeHtml4(form.getFacilityId()), true, true, false, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (FacilityNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        listInfoData = ConvertListUtil.scopeInfoDataListToArrayList(records, managerIp);

        return listInfoData;
    }

}
