/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;

import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ViewListInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetEventListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorEventForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EventFilterPropertyUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

public class GetEventListBusiness {

    public List<ArrayList<Object>> getEventList(MonitorEventForm form,
            Property condition, LinkedHashMap<String, LoginManager> loginManagerMap, Locale locale)
            throws HinemosWebException {
        List<ArrayList<Object>> listInfo = new ArrayList<ArrayList<Object>>();
        String managerIpForSearch = form.getManagerIpForSearch();
        if (condition != null) {
            Object[] listCondElement = condition.getChildren();
            for (int count = 0; count < listCondElement.length; count++) {
                Property condElement = (Property) listCondElement[count];
                if (MonitorConstants.FILTER_CONDITION_ID_MANAGER.equals(condElement.getID())) {
                    String managerIp = (String)condElement.getValue();
                    if (managerIp != null && !managerIp.trim().isEmpty()) {
                        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty() && !managerIp.equals(managerIpForSearch)) {
                            return listInfo;
                        }
                        listInfo.addAll(getEventList(form, condition, loginManagerMap.get(managerIp).endpointManager, locale, managerIp));
                        listInfo = DataProcess.doSortListDataInfo(form, listInfo, GetEventListTableDefine.SORT_COLUMN_INDEX, GetEventListTableDefine.SORT_ORDER);
                        ConvertListUtil.sanitizeEventDataInfo(listInfo);

                        return listInfo;
                    }
                    break;
                }
            }
        }
        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty()) {
            listInfo.addAll(getEventList(form, condition, loginManagerMap.get(managerIpForSearch).endpointManager, locale, managerIpForSearch));
            listInfo = DataProcess.doSortListDataInfo(form, listInfo, GetEventListTableDefine.SORT_COLUMN_INDEX, GetEventListTableDefine.SORT_ORDER);
            ConvertListUtil.sanitizeEventDataInfo(listInfo);

            return listInfo;
        }
        Set<String> managerIpSet = loginManagerMap.keySet();
        Iterator<String> iterator = managerIpSet.iterator();
        while (iterator.hasNext()) {
            String managerIp = iterator.next();
            LoginManager loginManager = loginManagerMap.get(managerIp);
            // シングルログインの場合、マネージャIPが不要なので、nullに設定
            if (managerIpSet.size() <= 1) {
                managerIp = null;
            }
            listInfo.addAll(getEventList(form, condition, loginManager.endpointManager, locale, managerIp));
        }

        listInfo = DataProcess.doSortListDataInfo(form, listInfo, GetEventListTableDefine.SORT_COLUMN_INDEX, GetEventListTableDefine.SORT_ORDER);
        ConvertListUtil.sanitizeEventDataInfo(listInfo);

        return listInfo;
    }

    private ArrayList<ArrayList<Object>> getEventList(MonitorEventForm form,
            Property condition, EndpointManager endpointManager, Locale locale, String managerIp)
            throws HinemosWebException {

        ViewListInfo records = null;

        if (condition == null) {
            records = getViewListInfo(form, endpointManager);
        } else {
            records = getViewListInfo(form, condition, endpointManager, locale);
        }

        ArrayList<ArrayList<Object>> listInfo = ConvertListUtil
            .eventLogDataListToArrayList(records.getEventList(), managerIp);

        return listInfo;
    }

    private ViewListInfo getViewListInfo(MonitorEventForm form,
            EndpointManager endpointManager) throws HinemosWebException {

        ViewListInfo records = null;
        try {
            records = MonitorEndpointWrapper.getEventList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    null, form.getMaxRowNum(), endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        return records;
    }

    private ViewListInfo getViewListInfo(MonitorEventForm form,
            Property condition, EndpointManager endpointManager, Locale locale)
            throws HinemosWebException {

        ViewListInfo records = null;
        try {
            PropertyUtil.deletePropertyDefine(condition);
            EventFilterInfo filter = EventFilterPropertyUtil.property2dto(condition, locale);
            records = MonitorEndpointWrapper.getEventList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    filter, form.getMaxRowNum(), endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        return records;
    }

}
