/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;

import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.EventBatchConfirmInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.bean.ConfirmConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.form.MonitorEventForm;
import com.necsoft.hinemos.webclient.monitor.util.EventBatchConfirmPropertyUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

/**
 * イベント情報を一括確認の処理を実行するビジネスクラス
 */
public class EventBatchConfirmBusiness {

    public String batchconfirm(MonitorEventForm form,
        Property condition, LinkedHashMap<String, LoginManager> loginManagerMap, Locale locale)
    throws HinemosWebException {

        // 一括確認の条件一覧データを取得
        if (condition != null) {
            Object[] listCondElement = condition.getChildren();
            for (int count = 0; count < listCondElement.length; count++) {
                Property condElement = (Property) listCondElement[count];
                if (MonitorConstants.FILTER_CONDITION_ID_MANAGER.equals(condElement.getID())) {
                    String managerIp = (String)condElement.getValue();
                    if (managerIp != null && !managerIp.trim().isEmpty()) {
                        return batchconfirm(form, condition, loginManagerMap.get(managerIp).endpointManager, locale) ? null : managerIp;
                    }
                }
            }
        }
        String managerIpForSearch = form.getManagerIpForSearch();
        if (managerIpForSearch != null && !managerIpForSearch.trim().isEmpty()) {
            return batchconfirm(form, condition, loginManagerMap.get(managerIpForSearch).endpointManager, locale) ? null : managerIpForSearch;
        }
        Set<String> managerIpSet = loginManagerMap.keySet();
        Iterator<String> iterator = managerIpSet.iterator();

        // 操作権限を持っていないマネージャのIP
        String unavailableManagerIp = null;
        while (iterator.hasNext()) {
            String managerIp = iterator.next();
            LoginManager loginManager = loginManagerMap.get(managerIp);
            if (!batchconfirm(form, condition, loginManager.endpointManager, locale) && unavailableManagerIp == null) {
                unavailableManagerIp = managerIp;
            }
        }
        return unavailableManagerIp;
    }

    private boolean batchconfirm(MonitorEventForm form,
        Property condition, EndpointManager endpointManager, Locale locale)
    throws HinemosWebException {

        // 一括確認の条件一覧データを取得
        if (condition != null) {
            try {
                PropertyUtil.deletePropertyDefine(condition);
                EventBatchConfirmInfo info = EventBatchConfirmPropertyUtil.property2dto(condition, locale);
                MonitorEndpointWrapper.modifyBatchConfirm(ConfirmConstant.TYPE_CONFIRMED,
                        StringEscapeUtils.unescapeHtml4(form.getFacilityId()), info, endpointManager);
            } catch (InvalidRole_Exception e) {
                // 操作権なしの場合
                return false;
            } catch (HinemosUnknown_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (InvalidUserPass_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (WebServiceException e) {
                // Hinemosマネージャより応答がありませんでした。ログアウトします。
                throw new HinemosWebException("message.force.disconnect");
            }

            return true;
        }
        return false;
    }
}
