/*

Copyright (C) NEC Corporation 2012-2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.monitor;

/**
 * 監視管理機能用の定数を定義するクラス
 */
public interface MonitorConstants {

    /** スコープ情報一覧の項目(マネージャ列あり) */
    static final int NUMBER_HEADER_SCOPE_WITH_MANAGER = 4;

    /** スコープ情報一覧の項目(マネージャ列なし) */
    static final int NUMBER_HEADER_SCOPE_WITHOUT_MANAGER = 3;

    /** ステータス情報一覧の項目(マネージャ列あり) */
    static final int NUMBER_HEADER_STATUS_WITH_MANAGER = 12;

    /** ステータス情報一覧の項目(マネージャ列なし) */
    static final int NUMBER_HEADER_STATUS_WITHOUT_MANAGER = 11;
    /** Set name of filter status properties */
    static final String STATUS_FILTER_PROPERTIES = "status_filter_properties";
    static final String STATUS_FILTER_PROPERTIES_LANG = "status_filter_properties_lang";

    /** イベント情報一覧の項目(マネージャ列あり) */
    static final int NUMBER_HEADER_EVENT_WITH_MANAGER = 15;

    /** イベント情報一覧の項目(マネージャ列なし) */
    static final int NUMBER_HEADER_EVENT_WITHOUT_MANAGER = 14;
    /** Set name of filter event properties */
    static final String EVENT_FILTER_PROPERTIES = "event_filter_properties";
    static final String EVENT_FILTER_PROPERTIES_LANG = "event_filter_properties_lang";
    /** Set name of batch confirm properties */
    static final String EVENT_BATCH_CONFIRM_PROPERTIES = "event_batch_confirm_properties";
    static final String EVENT_BATCH_CONFIRM_PROPERTIES_LANG = "event_batch_confirm_properties_lang";

    /** フィルタダイアログのマネージャ項目のID */
    static final String FILTER_CONDITION_ID_MANAGER = "manager";

    // The separate of display and hidden parts of field receive_time
    // NOTICE when repairs this value, because it's used two place which have
    // different situation
    //public static final String EVENT_SEPARATE_RECEIVE_TIME = ".";
}
