package com.necsoft.hinemos.webclient.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.common.Constants;

public class ParameterInitListener implements ServletContextListener, Constants {

    @Override
    public void contextDestroyed(ServletContextEvent event) {

    }

    @Override
    public void contextInitialized(ServletContextEvent event) {
        ServletContext application = event.getServletContext();
        // URL一覧ファイルパス
        application.setAttribute(AccessControlConstants.URL_LIST_FILE_PATH, application.getInitParameter(AccessControlConstants.URL_LIST_FILE_PATH));
        // 監視[ステータス]のデフォルト最大表示件数
        application.setAttribute(MONITOR_STATUS_MAX_ROW, Integer.parseInt(application.getInitParameter(MONITOR_STATUS_MAX_ROW)));
        // 監視[イベント]のデフォルト最大表示件数
        application.setAttribute(MONITOR_EVENT_MAX_ROW, Integer.parseInt(application.getInitParameter(MONITOR_EVENT_MAX_ROW)));
        // リポジトリ[ノード]のデフォルト最大表示件数
        application.setAttribute(REPOSITORY_NODE_MAX_ROW, Integer.parseInt(application.getInitParameter(REPOSITORY_NODE_MAX_ROW)));
        // ジョブ[履歴]のデフォルト最大表示件数
        application.setAttribute(JOB_HISTORY_MAX_ROW, Integer.parseInt(application.getInitParameter(JOB_HISTORY_MAX_ROW)));

    }

}
