/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.json;

import net.sf.json.JSON;
import net.sf.json.JSONSerializer;

/**
 * Base class for all JSON
 */
public class CommonJson {
    private int result;

    private Object message;

    /**
	 * 
	 */
    public CommonJson() {
        this.result = 0;
    }

    /**
     * Set result
     * 
     * @param result
     */
    public void setResult(int iResult) {
        this.result = iResult;
    }

    /**
     * Get error message
     * 
     * @return
     */
    public Object getMessage() {
        return message;
    }

    /**
     * Set error message
     * 
     * @param message
     */
    public void setMessage(Object message) {
        this.message = message;
    }

    /**
     * Get result
     * 
     * @return
     */
    public int getResult() {
        return this.result;
    }

    /**
     * Generate this object to JSON data
     * 
     * @return
     */
    public JSON toJSON() {
        return JSONSerializer.toJSON(this);
    }
}
