/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.util.HashMap;
import java.util.Map;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetForwardFileTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetNodeDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetScheduleTableDefine;

/**
 * This class used for Mapping data
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class JobMappingUtil {
    private static final Map<Integer, String> JOB_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         *
         */
        private static final long serialVersionUID = 7261193083575860188L;

        {
            put(GetJobTableDefine.JOB_ID, "jobId");
            put(GetJobTableDefine.JOB_NAME, "jobName");
            put(GetJobTableDefine.JOB_TYPE, "jobType");
            put(GetJobTableDefine.FACILITY_ID, "facilityId");
            put(GetJobTableDefine.SCOPE, "scope");
            put(GetJobTableDefine.WAIT_RULE, "waitRule");
            put(GetJobTableDefine.CREATE_USER, "createUser");
            put(GetJobTableDefine.CREATE_TIME, "createTime");
            put(GetJobTableDefine.UPDATE_USER, "updateUser");
            put(GetJobTableDefine.UPDATE_TIME, "updateTime");
        }
    };

    private static final Map<Integer, String> HISTORY_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 *
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetHistoryTableDefine.STATUS, "status");
            put(GetHistoryTableDefine.END_STATUS, "endStatus");
            put(GetHistoryTableDefine.END_VALUE, "endValue");
            put(GetHistoryTableDefine.SESSION_ID, "sessionId");
            put(GetHistoryTableDefine.JOB_ID, "jobId");
            put(GetHistoryTableDefine.JOB_NAME, "jobName");
            put(GetHistoryTableDefine.JOBUNIT_ID, "jobuinitId");
            put(GetHistoryTableDefine.JOB_TYPE, "jobType");
            put(GetHistoryTableDefine.FACILITY_ID, "messageId");
            put(GetHistoryTableDefine.SCOPE, "scope");
            put(GetHistoryTableDefine.SCHEDULED_START_TIME, "scheduledStartTime");
            put(GetHistoryTableDefine.START_RERUN_TIME, "startReturnTime");
            put(GetHistoryTableDefine.END_SUSPEND_TIME, "endSuspendTime");
            put(GetHistoryTableDefine.TRIGGER_TYPE, "triggerType");
            put(GetHistoryTableDefine.TRIGGER_INFO, "triggerInfo");
            put(GetHistoryTableDefine.MANAGER, "manager");
        }
    };

    private static final Map<Integer, String> JOB_DETAIL_COLUMN_NAME_MAP = new HashMap<Integer, String>() {

        /**
		 *
		 */
        private static final long serialVersionUID = 4862213824718976924L;

        {
            put(GetJobDetailTableDefine.TREE, "tree");
            put(GetJobDetailTableDefine.STATUS, "status");
            put(GetJobDetailTableDefine.END_STATUS, "endStatus");
            put(GetJobDetailTableDefine.END_VALUE, "endValue");
            put(GetJobDetailTableDefine.JOB_ID, "jobId");
            put(GetJobDetailTableDefine.JOB_NAME, "jobName");
            put(GetJobDetailTableDefine.JOBUNIT_ID, "jobunitId");
            put(GetJobDetailTableDefine.JOB_TYPE, "jobType");
            put(GetJobDetailTableDefine.FACILITY_ID, "facilityId");
            put(GetJobDetailTableDefine.SCOPE, "scope");
            put(GetJobDetailTableDefine.WAIT_RULE_TIME, "waitRuleTime");
            put(GetJobDetailTableDefine.START_RERUN_TIME, "startRerunTime");
            put(GetJobDetailTableDefine.END_SUSPEND_TIME, "endSuspendTime");
        }
    };

    private static final Map<Integer, String> JOB_SCHEDULE_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         *
         */
        private static final long serialVersionUID = 7261193083575860188L;

        {
            put(GetScheduleTableDefine.SCHE_ID, "scheId");
            put(GetScheduleTableDefine.SCHE_NAME, "scheName");
            put(GetScheduleTableDefine.JOB_ID, "jobId");
            put(GetScheduleTableDefine.JOB_NAME, "jobName");
            put(GetScheduleTableDefine.JOBUNIT_ID, "jobunitId");
            put(GetScheduleTableDefine.CALENDAR_ID, "calendarId");
            put(GetScheduleTableDefine.SCHEDULE, "schedule");
            put(GetScheduleTableDefine.VALID, "valid");
            put(GetScheduleTableDefine.CREATE_USER, "createUser");
            put(GetScheduleTableDefine.CREATE_TIME, "createTime");
            put(GetScheduleTableDefine.UPDATE_USER, "updateUser");
            put(GetScheduleTableDefine.UPDATE_TIME, "updateTime");
            put(GetScheduleTableDefine.MANAGER, "manager");
        }
    };

    private static final Map<Integer, String> JOB_NODE_DETAIL_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         *
         */
        private static final long serialVersionUID = 7261193083575860188L;

        {
            put(GetNodeDetailTableDefine.STATUS, "status");
            put(GetNodeDetailTableDefine.RETURN_VALUE, "returnValue");
            put(GetNodeDetailTableDefine.FACILITY_ID, "facilityId");
            put(GetNodeDetailTableDefine.FACILITY_NAME, "facilityName");
            put(GetNodeDetailTableDefine.START_RERUN_TIME, "startReturnTime");
            put(GetNodeDetailTableDefine.END_SUSPEND_TIME, "endSuspendTime");
            put(GetNodeDetailTableDefine.MESSAGE, "message");
        }
    };

    private static final Map<Integer, String> JOB_FILE_TRANFER_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         *
         */
        private static final long serialVersionUID = 7261193083575860188L;

        {
            put(GetForwardFileTableDefine.STATUS, "status");
            put(GetForwardFileTableDefine.END_STATUS, "endStatus");
            put(GetForwardFileTableDefine.FILE_NAME, "fileName");
            put(GetForwardFileTableDefine.SRC_FACILITY_ID, "srcFacilityId");
            put(GetForwardFileTableDefine.SRC_FACILITY_NAME, "srcFacilityName");
            put(GetForwardFileTableDefine.DEST_FACILITY_ID, "destFacilityId");
            put(GetForwardFileTableDefine.DEST_FACILITY_NAME, "destFacilityName");
            put(GetForwardFileTableDefine.START_RERUN_TIME, "startRerunTime");
            put(GetForwardFileTableDefine.END_SUSPEND_TIME, "endSuspendTime");
        }
    };

    public static final String getJobName(int id) {
        return JOB_COLUMN_NAME_MAP.get(id);
    }

    public static final String getHistoryName(int id) {
        return HISTORY_COLUMN_NAME_MAP.get(id);
    }

    public static final String getJobDetailName(int id) {
        return JOB_DETAIL_COLUMN_NAME_MAP.get(id);
    }

    public static final String getJobScheduleName(int id) {
        return JOB_SCHEDULE_COLUMN_NAME_MAP.get(id);
    }

    public static final String getJobNodeDetailName(int id) {
        return JOB_NODE_DETAIL_COLUMN_NAME_MAP.get(id);
    }

    public static final String getFileTranferName(int id) {
        return JOB_FILE_TRANFER_COLUMN_NAME_MAP.get(id);
    }
}
