/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.ws.common.Schedule;
import com.clustercontrol.ws.jobmanagement.JobDetailInfo;
import com.clustercontrol.ws.jobmanagement.JobForwardFile;
import com.clustercontrol.ws.jobmanagement.JobHistory;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNodeDetail;
import com.clustercontrol.ws.jobmanagement.JobSchedule;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.necsoft.hinemos.webclient.bean.JobTriggerTypeConstant;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetForwardFileTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetNodeDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetScheduleTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.bean.DayOfWeekConstant;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 表示用のリストに変換するクラス
 **/
public class ConvertListUtil {

    /**************************************************************************
     * Schedule
     */
    public static ArrayList<ArrayList<Object>> jobScheduleListToArrayList(
            List<JobSchedule> list, Locale locale, String managerIp) {

        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        Iterator<JobSchedule> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> schedule = new ArrayList<Object>();
            JobSchedule jobSche = itr.next();

            schedule.add(GetScheduleTableDefine.SCHE_ID, jobSche.getId());
            schedule.add(GetScheduleTableDefine.SCHE_NAME, jobSche.getName());
            schedule.add(GetScheduleTableDefine.JOB_ID, jobSche.getJobId());
            schedule.add(GetScheduleTableDefine.JOB_NAME, jobSche.getJobName());
            schedule.add(GetScheduleTableDefine.JOBUNIT_ID, jobSche.getJobunitId());
            schedule.add(GetScheduleTableDefine.CALENDAR_ID, jobSche.getCalendarId());
            schedule.add(GetScheduleTableDefine.SCHEDULE,
                    jobConvertScheduleToString(jobSche.getSchedule(), locale));
            schedule.add(GetScheduleTableDefine.VALID, jobSche.getValid());
            schedule.add(GetScheduleTableDefine.CREATE_USER, jobSche.getCreateUser());
            schedule.add(GetScheduleTableDefine.CREATE_TIME, jobSche.getCreateTime());
            schedule.add(GetScheduleTableDefine.UPDATE_USER, jobSche.getUpdateUser());
            schedule.add(GetScheduleTableDefine.UPDATE_TIME, jobSche.getUpdateTime());
            if (managerIp != null) {
                schedule.add(GetScheduleTableDefine.MANAGER, managerIp);
            }

            result.add(schedule);
        }
        return result;
    }

    private static String jobConvertScheduleToString (Schedule schedule, Locale locale){
        //データタイプが「スケジュール」の処理
        String scheduleString = null;
        DecimalFormat format = new DecimalFormat("00");
        if (schedule.getType() == ScheduleConstant.TYPE_DAY) {
            if (schedule.getMonth() != null) {
                scheduleString = format.format(schedule.getMonth()) +
                "/" + format.format(schedule.getDay()) + " " +
                format.format(schedule.getHour()) + ":" +
                format.format(schedule.getMinute());
            } else if (schedule.getDay() != null){
                scheduleString = format.format(schedule.getDay()) +
                WebMessages.getString("monthday", locale) + " " +
                format.format(schedule.getHour()) + ":" +
                format.format(schedule.getMinute());
            } else if (schedule.getHour() != null) {
                scheduleString = format.format(schedule.getHour()) + ":" +
                format.format(schedule.getMinute());
            } else if (schedule.getMinute() != null) {
                scheduleString = format.format(schedule.getMinute()) +
                WebMessages.getString("minute", locale);
            }
        } else if (schedule.getType() == ScheduleConstant.TYPE_WEEK){
            if (schedule.getHour() != null) {
                scheduleString = DayOfWeekConstant.typeToString(schedule.getWeek(), locale) +
                " " + format.format(schedule.getHour()) + ":" +
                format.format(schedule.getMinute());
            } else {
                scheduleString = DayOfWeekConstant.typeToString(schedule.getWeek(), locale) +
                " " + format.format(schedule.getMinute()) + WebMessages.getString("minute", locale);
            }
        } else {
            // ここは通らないはず。
            scheduleString = "";
        }
        return scheduleString;
    }

    /**
     * @param list
     */
    public static void sanitizeScheduleList(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            /** スケジュール名 */
            if (row.get(GetScheduleTableDefine.SCHE_NAME) != null) {
                row.set(GetScheduleTableDefine.SCHE_NAME, StringEscapeUtils
                        .escapeHtml4((row.get(GetScheduleTableDefine.SCHE_NAME)
                                .toString())));
            }

            /** ジョブ名 */
            if (row.get(GetScheduleTableDefine.JOB_NAME) != null) {
                row.set(GetScheduleTableDefine.JOB_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScheduleTableDefine.JOB_NAME).toString()));
            }

            /** スケジュール */
            if (row.get(GetScheduleTableDefine.SCHEDULE) != null) {
                row.set(GetScheduleTableDefine.SCHEDULE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScheduleTableDefine.SCHEDULE).toString()));
            }

            /** 新規作成ユーザ */
            if (row.get(GetScheduleTableDefine.CREATE_USER) != null) {
                row.set(GetScheduleTableDefine.CREATE_USER,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScheduleTableDefine.CREATE_USER).toString()));
            }

            /** 最終更新ユーザ */
            if (row.get(GetScheduleTableDefine.UPDATE_USER) != null) {
                row.set(GetScheduleTableDefine.UPDATE_USER,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScheduleTableDefine.UPDATE_USER).toString()));
            }
        }
    }

    /**************************************************************************
     * History
     */
    public static ArrayList<ArrayList<Object>> jobHistoryListToArrayList(
            List<JobHistory> list, String managerIp) {

        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        Iterator<JobHistory> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> history = new ArrayList<Object>();
            JobHistory jobHist = itr.next();

            history.add(GetHistoryTableDefine.STATUS, jobHist.getStatus());
            history.add(GetHistoryTableDefine.END_STATUS, jobHist.getEndStatus());
            history.add(GetHistoryTableDefine.END_VALUE, jobHist.getEndValue());
            history.add(GetHistoryTableDefine.SESSION_ID, jobHist.getSessionId());
            history.add(GetHistoryTableDefine.JOB_ID, jobHist.getJobId());
            history.add(GetHistoryTableDefine.JOB_NAME, jobHist.getJobName());
            history.add(GetHistoryTableDefine.JOBUNIT_ID, jobHist.getJobunitId());
            history.add(GetHistoryTableDefine.JOB_TYPE, jobHist.getJobType());
            history.add(GetHistoryTableDefine.FACILITY_ID, jobHist.getFacilityId());
            history.add(GetHistoryTableDefine.SCOPE, jobHist.getScope());
            history.add(GetHistoryTableDefine.SCHEDULED_START_TIME, jobHist.getScheduleDate());
            history.add(GetHistoryTableDefine.START_RERUN_TIME, jobHist.getStartDate());
            history.add(GetHistoryTableDefine.END_SUSPEND_TIME, jobHist.getEndDate());
            history.add(GetHistoryTableDefine.TRIGGER_TYPE, JobTriggerTypeConstant.stringToType(jobHist.getJobTriggerType()));
            history.add(GetHistoryTableDefine.TRIGGER_INFO, jobHist.getTriggerInfo());
            if (managerIp != null) {
                history.add(GetHistoryTableDefine.MANAGER, managerIp);
            }

            result.add(history);
        }

        return result;
    }

    public static void sanitizeHistoryList(List<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            /** ジョブID */
            if (row.get(GetHistoryTableDefine.JOB_ID) != null) {
                row.set(GetHistoryTableDefine.JOB_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.JOB_ID).toString()));
            }

            /** ジョブ名 */
            if (row.get(GetHistoryTableDefine.JOB_NAME) != null) {
                row.set(GetHistoryTableDefine.JOB_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.JOB_NAME).toString()));
            }

            /** 所属ジョブユニットのジョブID */
            if (row.get(GetHistoryTableDefine.JOBUNIT_ID) != null) {
                row.set(GetHistoryTableDefine.JOBUNIT_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.JOBUNIT_ID).toString()));
            }

            /** ファシリティID */
            if (row.get(GetHistoryTableDefine.FACILITY_ID) != null) {
                row.set(GetHistoryTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.FACILITY_ID).toString()));
            }

            /** スコープ */
            if (row.get(GetHistoryTableDefine.SCOPE) != null) {
                row.set(GetHistoryTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.SCOPE).toString()));
            }

            /** 実行契機情報 */
            if (row.get(GetHistoryTableDefine.TRIGGER_INFO) != null) {
                row.set(GetHistoryTableDefine.TRIGGER_INFO,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetHistoryTableDefine.TRIGGER_INFO).toString()));
            }
        }
    }

    /**************************************************************************
     * Job node detail
     */
    public static ArrayList<ArrayList<Object>> jobNodeDetailListToArrayList(
            List<JobNodeDetail> list) {
        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<JobNodeDetail> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> nodeDetail = new ArrayList<Object>();
            JobNodeDetail jobNodeDetail = itr.next();

            Long startDate;
            Long endDate;

            // Check startDate
            if (jobNodeDetail.getStartDate() == null) {
                startDate = null;
            } else {
                startDate = jobNodeDetail.getStartDate();
            }

            // Check endDate
            if (jobNodeDetail.getEndDate() == null) {
                endDate = null;
            } else {
                endDate = jobNodeDetail.getEndDate();
            }

            nodeDetail.add(GetNodeDetailTableDefine.STATUS,
                    jobNodeDetail.getStatus());
            nodeDetail.add(GetNodeDetailTableDefine.RETURN_VALUE,
                    jobNodeDetail.getEndValue());
            nodeDetail
                    .add(GetNodeDetailTableDefine.FACILITY_ID,
                            StringEscapeUtils.escapeHtml4(jobNodeDetail
                                    .getFacilityId()));
            nodeDetail.add(GetNodeDetailTableDefine.FACILITY_NAME,jobNodeDetail.getNodeName());
            nodeDetail
                    .add(GetNodeDetailTableDefine.START_RERUN_TIME, startDate);
            nodeDetail.add(GetNodeDetailTableDefine.END_SUSPEND_TIME, endDate);
            nodeDetail.add(GetNodeDetailTableDefine.MESSAGE, jobNodeDetail.getMessage());
            ret.add(nodeDetail);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeNodeDetailList(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            /** ファシリティ名 */
            if (row.get(GetNodeDetailTableDefine.FACILITY_NAME) != null) {
                row.set(GetNodeDetailTableDefine.FACILITY_NAME, StringEscapeUtils
                        .escapeHtml4((row.get(GetNodeDetailTableDefine.FACILITY_NAME)
                                .toString())));
            }

            /** メッセージ */
            if (row.get(GetNodeDetailTableDefine.MESSAGE) != null) {
                row.set(GetNodeDetailTableDefine.MESSAGE, StringEscapeUtils
                        .escapeHtml4((row.get(GetNodeDetailTableDefine.MESSAGE)
                                .toString())));
            }
        }
    }

    /**************************************************************************
     * Forward file
     */
    /**
     * @param list
     * @return
     */
    public static ArrayList<ArrayList<Object>> jobForwardFileListToArrayList(
            List<JobForwardFile> list) {
        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<JobForwardFile> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> forwardFile = new ArrayList<Object>();
            JobForwardFile jobForwarFile = itr.next();

            Object startDate;
            Object endDate;

            // Check startDate
            if (jobForwarFile.getStartDate() == null) {
                startDate = null;
            } else {
                startDate = jobForwarFile.getStartDate();
            }

            // Check endDate
            if (jobForwarFile.getEndDate() == null) {
                endDate = null;
            } else {
                endDate = jobForwarFile.getEndDate();
            }

            forwardFile.add(GetForwardFileTableDefine.STATUS,
                    jobForwarFile.getStatus());
            forwardFile.add(GetForwardFileTableDefine.END_STATUS,
                    jobForwarFile.getEndStatus());
            forwardFile.add(GetForwardFileTableDefine.FILE_NAME,
                    jobForwarFile.getFile());
            forwardFile.add(GetForwardFileTableDefine.SRC_FACILITY_ID,
                    jobForwarFile.getSrcFacility());
            forwardFile.add(GetForwardFileTableDefine.SRC_FACILITY_NAME,
                    jobForwarFile.getSrcFacilityName());
            forwardFile.add(GetForwardFileTableDefine.DEST_FACILITY_ID,
                    jobForwarFile.getDstFacilityId());
            forwardFile.add(GetForwardFileTableDefine.DEST_FACILITY_NAME,
                    jobForwarFile.getDstFacilityName());
            forwardFile.add(GetForwardFileTableDefine.START_RERUN_TIME,
                    startDate);
            forwardFile
                    .add(GetForwardFileTableDefine.END_SUSPEND_TIME, endDate);

            ret.add(forwardFile);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeForwardFileList(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(GetForwardFileTableDefine.FILE_NAME) != null) {
                row.set(GetForwardFileTableDefine.FILE_NAME,
                        StringEscapeUtils
                                .escapeHtml4(row.get(
                                        GetForwardFileTableDefine.FILE_NAME)
                                        .toString()));
            }

            if (row.get(GetForwardFileTableDefine.SRC_FACILITY_ID) != null) {
                String srcFacilityId = StringEscapeUtils.escapeHtml4(row.get(
                        GetForwardFileTableDefine.SRC_FACILITY_ID).toString());
                row.set(GetForwardFileTableDefine.SRC_FACILITY_ID,
                        srcFacilityId);
            }

            if (row.get(GetForwardFileTableDefine.SRC_FACILITY_NAME) != null) {
                row.set(GetForwardFileTableDefine.SRC_FACILITY_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetForwardFileTableDefine.SRC_FACILITY_NAME)
                                .toString()));
            }

            if (row.get(GetForwardFileTableDefine.DEST_FACILITY_ID) != null) {
                row.set(GetForwardFileTableDefine.DEST_FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetForwardFileTableDefine.DEST_FACILITY_ID)
                                .toString()));
            }

            if (row.get(GetForwardFileTableDefine.DEST_FACILITY_NAME) != null) {
                row.set(GetForwardFileTableDefine.DEST_FACILITY_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetForwardFileTableDefine.DEST_FACILITY_NAME)
                                .toString()));
            }
        }
    }
    /**************************************************************************
     * Job detail
     */
    public static void generateSerializedData(ArrayList<ArrayList<Object>> listInfoData,
            List<JobTreeItem> listItem, int level, String parentId) {

      Iterator<JobTreeItem> itr = listItem.iterator();
      boolean isLeaf;

      while (itr.hasNext()) {
            JobTreeItem jobTreeItem = itr.next();

            if (jobTreeItem.getChildren().size() != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            //Add data
            listInfoData.add(jobDetailListToArrayList(jobTreeItem, level, parentId, isLeaf));

            //Check children
            if(!isLeaf)
            {
                String jobParentId;
                jobParentId = jobTreeItem.getData().getId();
                generateSerializedData(listInfoData, jobTreeItem.getChildren(),level+1, jobParentId);
            }
        }
    }

    private static ArrayList<Object> jobDetailListToArrayList(
            JobTreeItem jobTreeItem, int level, String parentId, boolean isLeaf) {

        ArrayList<Object> jobDetail = new ArrayList<Object>();
        JobInfo jobInfo = jobTreeItem.getData();
        JobDetailInfo jobDetailInfo = jobTreeItem.getDetail();

        jobDetail.add(GetJobDetailTableDefine.TREE, "");
        jobDetail.add(GetJobDetailTableDefine.STATUS,
                jobDetailInfo.getStatus());
        jobDetail.add(GetJobDetailTableDefine.END_STATUS,
                jobDetailInfo.getEndStatus());
        jobDetail.add(GetJobDetailTableDefine.END_VALUE,
                jobDetailInfo.getEndValue());
        jobDetail.add(GetJobDetailTableDefine.JOB_ID,
                jobInfo.getId());
        jobDetail.add(GetJobDetailTableDefine.JOB_NAME,
                jobInfo.getName());
        jobDetail.add(GetJobDetailTableDefine.JOBUNIT_ID,
                jobInfo.getJobunitId());
        jobDetail.add(GetJobDetailTableDefine.JOB_TYPE,
                jobInfo.getType());
        jobDetail.add(GetJobDetailTableDefine.FACILITY_ID,
                jobDetailInfo.getFacilityId());
        jobDetail.add(GetJobDetailTableDefine.SCOPE,
                jobDetailInfo.getScope());
        jobDetail.add(GetJobDetailTableDefine.WAIT_RULE_TIME,
                jobDetailInfo.getWaitRuleTime());
        jobDetail.add(GetJobDetailTableDefine.START_RERUN_TIME,
                jobDetailInfo.getStartDate());
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME,
                jobDetailInfo.getEndDate());

        // Add properties for tree grid
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 1, jobInfo.getId()); // Add key for row
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 2, level);
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 3, parentId);
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 4, isLeaf);
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 5, true);
        jobDetail.add(GetJobDetailTableDefine.END_SUSPEND_TIME + 6, JsConstant.TREE_LOADED);

        return jobDetail;
    }

    public static void sanitizeJobDetailList(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            /** ジョブID */
            if (row.get(GetJobDetailTableDefine.JOB_ID) != null) {
                row.set(GetJobDetailTableDefine.JOB_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetJobDetailTableDefine.JOB_ID).toString()));
            }

            /** ジョブ名 */
            if (row.get(GetJobDetailTableDefine.JOB_NAME) != null) {
                row.set(GetJobDetailTableDefine.JOB_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetJobDetailTableDefine.JOB_NAME).toString()));
            }

            /** 所属ジョブユニットのジョブID */
            if (row.get(GetJobDetailTableDefine.JOBUNIT_ID) != null) {
                row.set(GetJobDetailTableDefine.JOBUNIT_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetJobDetailTableDefine.JOBUNIT_ID).toString()));
            }

            /** ファシリティID */
            if (row.get(GetJobDetailTableDefine.FACILITY_ID) != null) {
                row.set(GetJobDetailTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetJobDetailTableDefine.FACILITY_ID).toString()));
            }

            /** スコープ */
            if (row.get(GetJobDetailTableDefine.SCOPE) != null) {
                row.set(GetJobDetailTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetJobDetailTableDefine.SCOPE).toString()));
            }
        }
    }
}
