/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetScheduleTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetScheduleTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for display header of schedule
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScheduleTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetScheduleTableDefineServlet.class);

    /**
     * Get header list
     *
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    @Override
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();
        try {
            HttpSession session = request.getSession();
            @SuppressWarnings("unchecked")
            LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            Set<String> managerIpSet = loginManagerMap.keySet();
            //Get Data
            GetScheduleTableDefineBusiness business = new GetScheduleTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = business.getScheduleTableDefine(request.getLocale(), managerIpSet.size() > 1);

            //Format column data
            setModelProperties(tblDefine);

            //Convert header to JSON structure
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    JobManagementConstants.ROW_NUM,
                    GetScheduleTableDefine.SORT_COLUMN_INDEX,
                    GetScheduleTableDefine.SORT_ORDER);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(GetScheduleTableDefine.VALID).setFormatter(
                JsConstant.GRID_FMATTER_VALID);

        tblDefine.get(GetScheduleTableDefine.CREATE_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetScheduleTableDefine.UPDATE_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);
    }
}