/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobTreeBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.json.JobTreeJson;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for get Job tree
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTreeServlet extends CommonServlet {
    private static final long serialVersionUID = -4383433394811974899L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobTreeServlet.class);

    /**
     * Get Job tree
     *
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    @Override
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = null;
        JobTreeJson jobTreeJs = new JobTreeJson();

        try {
            // Load job tree
            JobTreeItem jobTreeItem = null;
            HttpSession session = request.getSession(true);
            GetJobTreeBusiness job = new GetJobTreeBusiness();

            synchronized(session) {
                @SuppressWarnings("unchecked")
                LinkedHashMap<String, LoginManager> loginManagerMap = (LinkedHashMap<String, LoginManager>) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
                Set<String> managerIpSet = loginManagerMap.keySet();
                Iterator<String> iterator = managerIpSet.iterator();
                while (iterator.hasNext()) {
                    String managerIp = iterator.next();
                    LoginManager loginManager = loginManagerMap.get(managerIp);
                    // シングルログインの場合、マネージャIPが不要なので、nullに設定
                    if (managerIpSet.size() <= 1) {
                        managerIp = null;
                    }
                    jobTreeItem = job.getJobTree(loginManager.endpointManager, managerIp);

                    // Create JSON
                    job.doConvertToJson(jobTreeJs, jobTreeItem, getUserName(request, managerIp), managerIp);
                }
                result = jobTreeJs;
            }

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }

        return result;
    }
}
