/*

Copyright (C) NEC Corporation 2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.necsoft.hinemos.webclient.jobmanagement.business;

import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.NodeOperationInfo;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This business class is used for Operation job
 **/
public class OperationJobBusiness {

    /**
     * ジョブ開始／ジョブ停止を行
     *
     * @return なし
     */
    public boolean operationJob(NodeOperationInfo info,
            EndpointManager endpointManager) throws HinemosWebException {

        try {
            JobEndpointWrapper.operationJob(info, endpointManager);
        } catch (InvalidRole_Exception e) {
            // 操作権なしの場合
            return false;
        } catch (Exception e) {
            if (e.getCause() instanceof NullPointerException) {
                // 終了値未入力時、エラーダイアログを表示する
                throw new HinemosWebException("message.job.21");
            } else if (e.getCause() instanceof IllegalStateException) {
                // 実行エラー時、エラーダイアログを表示する
                throw new HinemosWebException("message.job.36");
            } else {
                // 実行エラー時、エラーダイアログを表示する
                throw new HinemosWebException("message.job.34", e.getCause());
            }
        }

        return true;
    }
}