/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobManagementUserInfo;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import com.clustercontrol.ws.jobmanagement.NotifyNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.UserNotFound_Exception;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.bean.JobTreeBean;
import com.necsoft.hinemos.webclient.jobmanagement.json.JobTreeJson;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobPropertyUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get Job tree
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTreeBusiness {
    /** パスセパレータ */
    private static final String SEPARATOR = ">";

    /**
     * Get job list
     * @return JobTreeJson
     * @throws HinemosWebException
     */
    public JobTreeItem getJobTree(EndpointManager endpointManager, String managerIp)
            throws HinemosWebException {

        // JobTree を取得
        JobTreeItem jobTreeItem = null;

        try {
            jobTreeItem = JobEndpointWrapper.getJobTree(false, endpointManager, managerIp);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (JobMasterNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (NotifyNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (UserNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        JobPropertyUtil.setJobFullTree(jobTreeItem, endpointManager);
        return jobTreeItem;
    }

    public JobTreeJson doConvertToJson(JobTreeJson jobTreeJs, JobTreeItem jobTreeItem, String userName, String managerIp) {
        // Create data JSON
        List<JobTreeItem> treeItems = jobTreeItem.getChildren();
        if (jobTreeJs == null) {
            jobTreeJs = new JobTreeJson();
        }
        for (int cnt = 0; cnt < treeItems.size(); cnt++) {
            jobTreeJs
                    .addJobTree(treeItem2TreeBean(treeItems.get(cnt), userName, managerIp));
        }

        return jobTreeJs;
    }

    /**
     * Convert JobTreeItem to FacilityTreeBean
     *
     * @param treeItem
     * @param path
     * @param key
     * @return JobTreeBean
     */
    private JobTreeBean treeItem2TreeBean(JobTreeItem treeItem, String userName, String managerIp) {
        JobTreeBean treeBean = new JobTreeBean();
        JobInfo jobInfo = treeItem.getData();

        StringBuffer title = new StringBuffer(jobInfo.getName());
        String jobId = jobInfo.getId();
        Integer type = jobInfo.getType();

        if (type == JobConstant.TYPE_COMPOSITE) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOB_COMPOSITE);
        } else {
            // Append title
            title.append(" (");
            title.append(jobId);
            title.append(")");

            // Set data for Node
            treeBean.setJobData(getJobData(jobInfo));
        }

        // Set component of JobTreeBean
        treeBean.setTitle(StringEscapeUtils.escapeHtml4(title.toString()));
        treeBean.setTooltip(StringEscapeUtils.escapeHtml4(title.toString()));
        treeBean.setJobId(jobId);
        treeBean.setPath(StringEscapeUtils.escapeHtml4(getPath(treeItem)));
        treeBean.setJobunitId(jobInfo.getJobunitId());
        treeBean.setManagerIp(managerIp);

        // Set children of node
        if (type == JobConstant.TYPE_FILEJOB) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_FILEJOB);
        } else if (type == JobConstant.TYPE_JOB) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOB);
        } else {
            // Set class for FacilityTreeBean
            treeBean.setIsFolder(true);
            if (type == JobConstant.TYPE_JOBUNIT) {
                if ((userName != null)
                        && checkPermissionJobunit(jobInfo.getManagementUser(),
                                userName)) {
                    treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOBUNIT);
                } else {
                    treeBean.setAddClass(JobManagementConstants.CSS_FORBIDEDEN_TREE_JOBUNIT);
                }
            } else if (type == JobConstant.TYPE_JOBNET) {
                treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOBNET);
            }

            // Set children for this JobTreeBean
            List<JobTreeItem> treeItems = treeItem.getChildren();

            // 子ノードリストを取得
            for (int cnt = 0; cnt < treeItems.size(); cnt++) {
                treeBean.addChildren(treeItem2TreeBean(treeItems.get(cnt),
                        userName, managerIp));
            }
        }

        return treeBean;
    }

    private Map<String, Object> getJobData(JobInfo jobInfo) {

        Map<String, Object> jobData = new HashMap<String, Object>();

        jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.JOB_ID),
                StringEscapeUtils.escapeHtml4(jobInfo.getId()));
        jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.JOB_NAME),
                StringEscapeUtils.escapeHtml4(jobInfo.getName()));
        jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.JOB_TYPE),
                jobInfo.getType());

        JobCommandInfo exec = jobInfo.getCommand();
        if (exec instanceof JobCommandInfo) {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.FACILITY_ID),
                    StringEscapeUtils.escapeHtml4(exec.getFacilityID()));
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.SCOPE),
                    StringEscapeUtils.escapeHtml4(exec.getScope()));
        } else {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.FACILITY_ID),
                    null);
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.SCOPE), null);
        }

        JobWaitRuleInfo waitRule = jobInfo.getWaitRule();
        if (waitRule instanceof JobWaitRuleInfo) {
            if (waitRule.getObject() != null && waitRule.getObject().size() > 0) {
                jobData.put(
                        JobMappingUtil.getJobName(GetJobTableDefine.WAIT_RULE),
                        YesNoConstant.TYPE_YES);
            } else {
                jobData.put(
                        JobMappingUtil.getJobName(GetJobTableDefine.WAIT_RULE),
                        YesNoConstant.TYPE_NO);
            }
        } else {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.WAIT_RULE),
                    YesNoConstant.TYPE_NO);
        }

        jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.CREATE_USER),
                jobInfo.getCreateUser());
        if (jobInfo.getCreateTime() != null) {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.CREATE_TIME),
                    jobInfo.getCreateTime());
        } else {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.CREATE_TIME),
                    null);
        }
        jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.UPDATE_USER),
                jobInfo.getUpdateUser());
        if (jobInfo.getUpdateTime() != null) {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.UPDATE_TIME),
                    jobInfo.getUpdateTime());
        } else {
            jobData.put(JobMappingUtil.getJobName(GetJobTableDefine.UPDATE_TIME),
                    null);
        }
        // Set other content
        return jobData;
    }

    private boolean checkPermissionJobunit(
            List<JobManagementUserInfo> arrJobManagementUser,
            String userName) {
        if (arrJobManagementUser == null) {
            return false;
        }

        if (arrJobManagementUser.size() == 0) {
            return true;
        }

        for (int count = 0; count < arrJobManagementUser.size(); count++) {
            JobManagementUserInfo mngUserInfo = arrJobManagementUser.get(count);
            if (mngUserInfo.getUserId().equals(userName)) {
                return true;
            }
        }

        return false;
    }


    private String getPath(JobTreeItem treeItem) {

        // トップ("ジョブ")の場合は、文字を出力しません。
        if (treeItem.getData().getType() == JobConstant.TYPE_COMPOSITE) {
            return "";
        }

        StringBuffer buffer = new StringBuffer();

        buffer.append(treeItem.getData().getName());

        JobTreeItem parent = treeItem.getParent();
        while (parent != null
                && parent.getData().getType() != JobConstant.TYPE_COMPOSITE) {

            buffer.insert(0, SEPARATOR);
            buffer.insert(0, parent.getData().getName());
            parent = parent.getParent();
        }

        return buffer.toString();
    }
}
