/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryTableDefine;

/**
 * This class used for get header list
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryTableDefineBusiness {

    /**
     * Get header list
     *
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     */
    public ArrayList<TableColumnInfoJs> getHistoryTableDefine(Locale locale, boolean isManagerIpRequired)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // ジョブ[履歴]テーブルヘッダー定義データを取得
        tblDefine = GetHistoryTableDefine.get(locale, isManagerIpRequired);

        // ジョブ[履歴]テーブルヘッダー定義データの項目数チェック
        if (isManagerIpRequired) {
            // 項目数が不正の場合
            if (tblDefine.size() != JobManagementConstants.HISTORY_HEADER_NUM_WITH_MANAGER) {
                throw new HinemosWebHeaderInvalidException("exception.header.number");
            }
        } else {
            // 項目数が不正の場合
            if (tblDefine.size() != JobManagementConstants.HISTORY_HEADER_NUM_WITHOUT_MANAGER) {
                throw new HinemosWebHeaderInvalidException("exception.header.number");
            }
        }

        return tblDefine;
    }
}