/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;

import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobForwardFile;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetForwardFileTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.ForwardFileForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get Forward File list
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetForwardFileBusiness {

    /**
     * Get Forward File list
     *
     * @param form
     *            : ForwardFileForm
     * @return ArrayList<JobForwardFile>
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList<Object>> getForwardFile(ForwardFileForm form,
        EndpointManager endpointManager) throws HinemosWebException {

        List<JobForwardFile> listItem = null;

        try {
            listItem = JobEndpointWrapper.getForwardFileList(
                    form.getSessionId(),
                    StringEscapeUtils.unescapeHtml4(form.getJobunitId()),
                    StringEscapeUtils.unescapeHtml4(form.getJobId()),
                    endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (JobInfoNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
            .jobForwardFileListToArrayList(listItem);

        ConvertListUtil.sanitizeForwardFileList(list);

        DataProcess.doSortListDataInfo(form, list,
                GetForwardFileTableDefine.SORT_COLUMN_INDEX,
                GetForwardFileTableDefine.SORT_ORDER);

        return list;
    }
}