/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.bean;

import java.util.Calendar;
import java.util.Locale;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * クライアントで用いる曜日の定数クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DayOfWeekConstant {
	/** 日曜日 */
	public static final int TYPE_SUNDAY = Calendar.SUNDAY;

	/** 月曜日 */
	public static final int TYPE_MONDAY = Calendar.MONDAY;

	/** 火曜日 */
	public static final int TYPE_TUESDAY = Calendar.TUESDAY;

	/** 水曜日 */
	public static final int TYPE_WEDNESDAY = Calendar.WEDNESDAY;

	/** 木曜日 */
	public static final int TYPE_THURSDAY = Calendar.THURSDAY;

	/** 金曜日 */
	public static final int TYPE_FRIDAY = Calendar.FRIDAY;

	/** 土曜日 */
	public static final int TYPE_SATURDAY = Calendar.SATURDAY;

	/**
	 * 種別から文字列に変換します。
	 * 
	 * @param type
	 * @return
	 */
	public static String typeToString(int type, Locale locale) {
		if (type == TYPE_SUNDAY) {
			return WebMessages.getString("sunday", locale); /** 日曜日 */
		} else if (type == TYPE_MONDAY) {
			return WebMessages.getString("monday", locale); /** 月曜日 */
		} else if (type == TYPE_TUESDAY) {
			return WebMessages.getString("tuesday", locale); /** 火曜日 */
		} else if (type == TYPE_WEDNESDAY) {
			return WebMessages.getString("wednesday", locale); /** 水曜日 */
		} else if (type == TYPE_THURSDAY) {
			return WebMessages.getString("thursday", locale); /** 木曜日 */
		} else if (type == TYPE_FRIDAY) {
			return WebMessages.getString("friday", locale); /** 金曜日 */
		} else if (type == TYPE_SATURDAY) {
			return WebMessages.getString("saturday", locale); /** 土曜日 */
		}
		return "";
	}

	/**
	 * 文字列から種別に変換します。
	 * 
	 * @param type
	 * @return
	 */
	public static int stringToType(String string, Locale locale) {
		if (string.equals(WebMessages.getString("sunday", locale))) {
			return TYPE_SUNDAY; /** 日曜日 */
		} else if (string.equals(WebMessages.getString("monday", locale))) {
			return TYPE_MONDAY; /** 月曜日 */
		} else if (string.equals(WebMessages.getString("tuesday", locale))) {
			return TYPE_TUESDAY; /** 火曜日 */
		} else if (string.equals(WebMessages.getString("wednesday", locale))) {
			return TYPE_WEDNESDAY; /** 水曜日 */
		} else if (string.equals(WebMessages.getString("thursday", locale))) {
			return TYPE_THURSDAY; /** 木曜日 */
		} else if (string.equals(WebMessages.getString("friday", locale))) {
			return TYPE_FRIDAY; /** 金曜日 */
		} else if (string.equals(WebMessages.getString("saturday", locale))) {
			return TYPE_SATURDAY; /** 土曜日 */
		}
		return -1;
	}
}