/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[スケジュール]ビューのテーブル定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScheduleTableDefine {

    /** スケジュールID */
    public static final int SCHE_ID = 0;
    /** スケジュール名 */
    public static final int SCHE_NAME = 1;
    /** ジョブID */
    public static final int JOB_ID = 2;
    /** ジョブ名 */
    public static final int JOB_NAME = 3;
    /** ジョブユニットID */
    public static final int JOBUNIT_ID = 4;
    /** カレンダID */
    public static final int CALENDAR_ID = 5;
    /** スケジュール */
    public static final int SCHEDULE = 6;
    /** 有効/無効 */
    public static final int VALID = 7;
    /** 新規作成ユーザ */
    public static final int CREATE_USER = 8;
    /** 作成日時 */
    public static final int CREATE_TIME = 9;
    /** 最終更新ユーザ */
    public static final int UPDATE_USER = 10;
    /** 最終更新日時 */
    public static final int UPDATE_TIME = 11;
    /** マネージャ */
    public static final int MANAGER = 12;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = SCHE_ID;
    /** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
    public static final int SORT_ORDER = 1;

    /**
     * ジョブ[スケジュール]ビューのテーブル定義を取得する
     *
     * @return テーブル定義情報
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale, boolean isManagerIpRequired) {
        /** テーブル定義配列*/
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(SCHE_ID, new TableColumnInfoJs(
                WebMessages.getString("schedule.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(SCHE_ID)));
        tableDefine.add(SCHE_NAME, new TableColumnInfoJs(
                WebMessages.getString("schedule.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(SCHE_NAME)));
        tableDefine.add(JOB_ID, new TableColumnInfoJs(
                WebMessages.getString("job.id", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(JOB_ID)));
        tableDefine.add(JOB_NAME, new TableColumnInfoJs(
                WebMessages.getString("job.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(JOB_NAME)));
        tableDefine.add(JOBUNIT_ID, new TableColumnInfoJs(
                WebMessages.getString("jobunit.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(JOBUNIT_ID)));
        tableDefine.add(CALENDAR_ID, new TableColumnInfoJs(
                WebMessages.getString("calendar.id", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(CALENDAR_ID)));
        tableDefine.add(SCHEDULE, new TableColumnInfoJs(
                WebMessages.getString("schedule", locale),
                TableColumnInfoJs.SCHEDULE, 100, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(SCHEDULE)));
        tableDefine.add(VALID, new TableColumnInfoJs(
                WebMessages.getString("valid", locale) + "/"
                        + WebMessages.getString("invalid", locale),
                TableColumnInfoJs.VALID, 80, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(VALID)));
        tableDefine.add(CREATE_USER, new TableColumnInfoJs(
                WebMessages.getString("creator.name", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(CREATE_USER)));
        tableDefine.add(CREATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("create.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(CREATE_TIME)));
        tableDefine.add(UPDATE_USER, new TableColumnInfoJs(
                WebMessages.getString("modifier.name", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(UPDATE_USER)));
        tableDefine.add(UPDATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("update.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobScheduleName(UPDATE_TIME)));
        if (isManagerIpRequired) {
            tableDefine.add(MANAGER, new TableColumnInfoJs(
                    WebMessages.getString("manager", locale),
                    TableColumnInfoJs.NONE, 150, SWT.LEFT,
                    JobMappingUtil.getJobScheduleName(MANAGER)));
        }

        return tableDefine;
    }
}