/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[一覧]ビューのテーブル定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTableDefine {

    /** ジョブID */
    public static final int JOB_ID = 0;
    /** ジョブ名 */
    public static final int JOB_NAME = 1;
    /** 種別 */
    public static final int JOB_TYPE = 2;
    /** ファシリティID */
    public static final int FACILITY_ID = 3;
    /** スコープ */
    public static final int SCOPE = 4;
    /** 待ち条件 */
    public static final int WAIT_RULE = 5;
    /** 新規作成ユーザ */
    public static final int CREATE_USER = 6;
    /** 作成日時 */
    public static final int CREATE_TIME = 7;
    /** 最終更新ユーザ */
    public static final int UPDATE_USER = 8;
    /** 最終更新日時 */
    public static final int UPDATE_TIME = 9;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = JOB_ID;
    /** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
    public static final int SORT_ORDER = 1;

    /**
     * ジョブ[一覧]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        tableDefine.add(JOB_ID, new TableColumnInfoJs(
                WebMessages.getString("job.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT, 
                JobMappingUtil.getJobName(JOB_ID)));
        
        tableDefine.add(JOB_NAME, new TableColumnInfoJs(
                WebMessages.getString("job.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getJobName(JOB_NAME)));
                
        tableDefine.add(JOB_TYPE, new TableColumnInfoJs(
                WebMessages.getString("type", locale),
                TableColumnInfoJs.JOB, 110, SWT.LEFT,
                JobMappingUtil.getJobName(JOB_TYPE)));
                
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id",
                locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobName(FACILITY_ID)));
                
        tableDefine.add(SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale),
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                JobMappingUtil.getJobName(SCOPE)));
                
        tableDefine.add(WAIT_RULE, new TableColumnInfoJs(
                WebMessages.getString("wait.rule", locale),
                TableColumnInfoJs.WAIT_RULE, 80, SWT.LEFT,
                JobMappingUtil.getJobName(WAIT_RULE)));
                
        tableDefine.add(CREATE_USER, new TableColumnInfoJs(
                WebMessages.getString("creator.name",
                locale), TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobName(CREATE_USER)));
                
        tableDefine.add(CREATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("create.time",
                locale), TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobName(CREATE_TIME)));
                
        tableDefine.add(UPDATE_USER, new TableColumnInfoJs(
                WebMessages.getString("modifier.name",
                locale), TableColumnInfoJs.NONE, 80, SWT.LEFT,
                JobMappingUtil.getJobName(UPDATE_USER)));
                
        tableDefine.add(UPDATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("update.time",
                locale), TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobName(UPDATE_TIME)));

        return tableDefine;
    }
}